##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

import sys, os, pickle
import pathcontrol
import strings

from pog import *
from folder import *
from emptyview import *

## fpsys : fonty python system.
## I debated calling it fpglobals.
## This is a common-ground for variables and defs that will be used from
## other modules - so they are global to everything.


## Ensure we have a .fontypython folder and a .fonts folder.
iPC = pathcontrol.PathControl ( ) #Make an instance - hence the small 'i'

##  Borrowed from wxglade.py
def determine_fontypython_path  (  ) :
    try:
        root = __file__
        if os.path.islink ( root ) :
            root = os.path.realpath ( root ) 
        return os.path.dirname ( os.path.abspath ( root )  ) 
    except:
        print "I'm sorry, but something is wrong."
        print "There is no __file__ variable. Please contact the author."
        sys.exit  (  ) 

####
## True if a folder. False if not. This does not mean it's a pog ...
def isFolder ( thing ):
    if os.path.isdir ( thing ): return True
    return False
####
##   
def isPog ( thing ):
    if thing in iPC.getPogNames (): return True
    if thing == "EMPTY": return True #Special case
    return False

#Consts
POG = 0
FOLDER = 1
CLOSE = 1 #Just close
UNINSTALL = 2 #uninstall the selected fonts from the pog
COPY = 3 #Copy the selected fonts from target to store

## Name of my images
PNGfilename = "tick.png" #default image

## The global vars to hold the state of the situation
class FPState:
    def __init__ ( self ):
        self.viewobject = None
        self.targetobject = None
        self.viewpattern = ""
        self.targetpattern = ""
        self.cantick = None
        self.action = "" # Will be "CLOSE", "REMOVE" or "APPEND"
        self.samepogs = False
        self.numticks = 0
        
state = FPState ( ) #The only instance of the state object -- app-wide

## Where my png images are.
mythingsdir = determine_fontypython_path  (  )  + "/things/" #point it at things/ folder

####
## Save and Load the conf file
class Configure:
    """Makes/Loads the conf file.
    Supplies size, pos, numinpage, text string and point size to other objects."""
    def __init__ ( self ) :
        ## Private vars
        self.__dontSaveNumInPage = False
        self.ipc = pathcontrol.PathControl ( )
        ## PUBLIC vars :  Set some defaults:
        self.size =  ( 400,600 ) 
        self.pos = ( 10, 10 )
        self.numinpage = 10
        self.text = "Jump the lazy dog fox"
        self.points = 64      
        self.lastview = "EMPTY" # a pog name or a folder path.
        self.usegui = "wxgui"
        self.max = True
        self.lastdir = self.ipc.home ( )
        
        self.__setData ( )
        
        if os.path.exists ( self.ipc.appConf ( ) ):
            try:
                pf = open ( self.ipc.appConf (  ) ,"r" )  #Using global self.ipc object!
                self.__data = pickle.load ( pf ) 
                pf.close (  ) 
            except:
                sys.exit ( "%s file appears to be damaged.\nPlease delete it and start again" %  self.ipc.appConf (  ) )
        else:
            print "No config file found, creating it with defaults."
            self.__write (  ) 
        ## Now get them into the instance vars:
        try:
            self.size = self.__data['size']
            self.pos= self.__data['pos']
            self.numinpage = self.__data['numinpage']
            self.text = self.__data['text']
            self.points= self.__data['points']
            self.lastview = self.__data['lastview']            
            self.usegui = self.__data['usegui']
            self.max = self.__data['max']
            self.lastdir = self.__data['lastdir']
            
        except KeyError:
            ## The conf file has keys that don't work for this version, chances are it's old.
            ## Let's delete and re-make it.
            try:
                os.unlink ( self.ipc.appConf (  ) )
            except:
                sys.exit ( "The fontypython config file is damaged.\nPlease remove it and start again" )
            self.__write ( )
    def dontSaveNumInPage ( self, flag ):
        self.__dontSaveNumInPage = flag
    def __setData ( self ):
        self.__data = {"size" : self.size,
                                "pos" : self.pos,
                                "numinpage" : self.numinpage,
                                "text" : self.text,
                                "points" : self.points,
                                "lastview" : self.lastview,
                                "usegui" : self.usegui,
                                "max" : self.max,
                                "lastdir" : self.lastdir
                                }
    def __write ( self ) :
        #If we are NOT to save the numinpage, then fetch it from what was there before.
        if self.__dontSaveNumInPage:
            self.numinpage = self.__data["numinpage"]
        self.__setData ( )
        try:
            pf = open ( self.ipc.appConf (  ) ,"w" ) 
            pickle.dump ( self.__data, pf ) 
            pf.close (  ) 
        except IOError:
            print "Could not write to the config file."
    def Save ( self ) :
        self.__write (  )  #Go write the file


## Our config instance - it will have one instance across
## all the modules that use it.
config = Configure ( )

def validateViewFolder ( foldername ):
    if state.viewobject: del state.viewobject
    ## Default assumptions in case of raised error.
    state.viewobject = EmptyView ( )
    state.viewpattern = "E" 
    ifolder = Folder ( foldername ) #raises : fontybugs.FolderHasNoFonts : BENIGN ERROR.
    ## Only continues if there is no problem.
    state.viewobject = ifolder
    config.lastview = foldername
    state.viewpattern = "F"
    markInactive ( )
    flushTicks ( )
    return

## A VIEW Pog can be EMPTY. This happens on the first run when there is no config file.
## There are other arcane situations too.
def validateViewPog ( newpog_name ):
    if state.viewobject: del state.viewobject
    if newpog_name == "EMPTY":
        ipog = EmptyView ( )
    else:
        ipog = Pog ( newpog_name ) 
    ## Test TARGETPOG to see if this is the same pogname
    ## The not None test is for first run - there is no targetobject yet just after cli.py calls us, so we
    ## do not want to access it or we get NoneType errors.
    if state.targetobject is not None and state.targetobject.name == newpog_name:
        state.samepogs = True
    else:
        state.samepogs = False
    ## Must gen the Pog to get a count of items:
    ipog.genList ( ) # Raises a fontybugs.PogInvalid error. THIS ENDS THE APP.
    ## Continue if all ok.
    state.viewobject = ipog
    config.lastview = newpog_name
    if len ( state.viewobject ) == 0:
        empty = True
        state.viewpattern = "E"
    else:
        empty = False
        state.viewpattern = "P"
        markInactive ( )
        flushTicks ( )
    return empty


## The app could begin with NO TARGET POG chosen.
## After that (in the gui) either a pog is chosen or NO POG is chosen (i.e. None)
## Therefore - there can NEVER BE a targetobject called EMPTY
## The CLI install/uninstall/purge never uses these validate routines.
def validateTargetPog ( newpog_name ):
    if state.targetobject: del state.targetobject
    ipog = Pog ( newpog_name ) 
    ## Must gen the Pog to get a count of items:
    ipog.genList ( ) # Raises fontybugs.PogInvalid error THIS ENDS THE APP.
    ## TEST VIEWPOG to see if this is the same pogname:
    if state.viewobject.label ( ) == newpog_name:
        ## The pog clicked in the TARGET is the same as what's ALREADY selected in the VIEW
        state.samepogs = True
    else: 
        state.samepogs = False
    quickinstalledflag = False
    if ipog.isInstalled ( ): quickinstalledflag  = True
    state.targetpattern = "P" 
    state.targetobject = ipog
    markInactive ( )
    flushTicks ( )
    return quickinstalledflag
    
## Mark each font item as inactive, as needs be.
## Also clears the ticks.
def markInactive ( ):
    if state.viewobject: state.viewobject.clearInactiveflags ( )
        
    if state.viewobject and state.targetobject:
        ## What's in TARGET must be inactive in VIEW
        pafBlist = [ i.paf for i in state.targetobject ]
        for iA in state.viewobject:
            if iA.paf in pafBlist:
                iA.msg = "Already in %s" % state.targetobject.name
                iA.inactive = True
        del pafBlist

def SetTargetPogToNone ( ):
    state.targetobject = None
    state.targetpattern = "N"
def SetViewPogToEmpty ( ):
    state.viewobject = EmptyView ( )
    state.viewpattern = "E"

def flushTicks ( ):
    for fi in state.viewobject:
        fi.ticked = False
    state.numticks = 0
