##    Fonty Python Copyright (C) 2006, 2007, 2008 Donn.C.Ingle
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This file is part of Fonty Python.
##    Fonty Python is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Fonty Python is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with Fonty Python.  If not, see <http://www.gnu.org/licenses/>.

import locale, gettext, sys, os

## Had to copy this from fpsys. When doing a proper installation
## the relative links to locale stop working. I need to know
## where fontypythonmodules actually lives.
try:
    root = __file__
    if os.path.islink(root):
        root = os.path.realpath(root)
    fontyroot = os.path.dirname(os.path.abspath(root)) 
except:
    print "I'm sorry, but something is wrong.\nThere is no __file__ variable. Please panic."
    raise SystemExit
        
## Dec 2007
## Try to setup the proper locale to get i18n started:
localedir = os.path.join(fontyroot, "locale")

try:
    locale.setlocale( locale.LC_ALL, "" ) # Mystical voodoo, don't ask me.
except:
    print "Your locale is not set correctly.\nPlease set the LANG like this:\nLANG=en_ZA.utf8\n(or whatever your locale is.)\nAnd start the program again."
    raise SystemExit
            
loc = locale.getlocale()[0]
## Get the _() function installed: Don't ask me *where* it goes ...
if loc == None:
    loc = locale.getlocale()
if loc == (None, None):
    print "Sorry, I can't find your locale.\nPlease set the LANG like this:\nLANG=en_ZA.utf8\n(or whatever your locale is.)\nAnd start the program again."
    raise SystemExit

## The .mo file is called "all.mo"
domain = "all"
gettext.install( domain, localedir, unicode = True )


try:
    lang = gettext.translation\
    (domain, localedir, languages = [loc] )
    lang.install(unicode = True )

except IOError:
    ## Could not find the domain.mo file.
    pass # default to English.
