#!/usr/bin/env python
##    Fonty Python Copyright (C) 2006, 2007, 2008 Donn.C.Ingle
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This file is part of Fonty Python.
##    Fonty Python is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Fonty Python is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with Fonty Python.  If not, see <http://www.gnu.org/licenses/>.


ver = "0.3.0" #Check fpversion.py

import sys

try:
    import wxversion
    #Let's make sure things will work.
    wxversion.ensureMinimal("2.6")
except:
    print """I cannot find "python-wxversion"
Please install this package - NB: ensure that
you use only the "Unicode build".

TIP
===
On my distro I can search for it like this:
sudo aptitude search python-wx
This returns many results, one of which is:
python-wxversion 
I then install it like this:
sudo aptitude install python-wxversion 

If you get long error messages, you will need to
install python-wxgtk*, where the star means the 
version number and it should be at least 2.6

You can also get the latest version from here:
http://wxpython.org/download.php
"""

#Try main wx
try:
    import wx
except:
    print """I cannot find "python-wxgtkX.Y"
Please install this package - NB: ensure that
you use only the "Unicode build".

TIP
===
On my distro I can search for it like this:
sudo aptitude search python-wx
This returns many results, one of which is:
python-wxgtk2.8
I then install it like this:
sudo aptitude install python-wxgtk2.8

Make sure it's at least version 2.6

You can also get the latest version from here:
http://wxpython.org/download.php
"""
    raise SystemExit
    
if not "unicode" in wx.PlatformInfo:
    print """I cannot find "python-wxgtkX.Y"
Please install this package - NB: ENSURE that
you use only the "Unicode build".

TIP
===
On my distro I can search for it like this:
sudo aptitude search python-wx
This returns many results, one of which is:
python-wxgtk2.8
I then install it like this:
sudo aptitude install python-wxgtk2.8

Make sure it's at least version 2.6

You can also get the latest version from here:
http://wxpython.org/download.php
"""
    raise SystemExit
    
#import PIL
try:
    import Image, ImageFont, ImageDraw #The PIL stuff.
except:
    print """I cannot find "python-imaging"
Please install this package.

TIP
===
On my distro I can search for it like this:
sudo aptitude search python-imag
This returns many results, one of which is:
python-imaging
I then install it like this:
sudo aptitude install python-imaging

Make sure it's at least version 1.1.6-1

You can also get the latest version from here:
http://www.pythonware.com/products/pil/index.htm
"""
    raise SystemExit
    
from distutils.core import setup

#This is a list of files to install, and where:
files = ["things/*", "pofiles/*", "locale/fr/LC_MESSAGES/*"]

setup(name = "fontypython",
    version = ver,
    description = "Fonty Python - manage fonts on Gnu/Linux",
    author = "Donn.C.Ingle",
    author_email = "donn.ingle@gmail.com",
    license = "GNU GPLv3",
    url = "https://savannah.nongnu.org/projects/fontypython/",
    packages = ['fontypythonmodules'],
    #'fontypython' package must contain 'files' (see list above)
    package_data = {'fontypythonmodules' : files},
    #'fontypython' is in the root.
    scripts = ["fontypython", "fp"],
    long_description = """Manage your fonts on Gnu/Linux.
NEWS : We now support TTF, OTF, Type1 (PFB, PFM) 
and TTC fonts.

Many designers have collections of font files in big
directory structures or on other media. Fonty Python
will let you gather your fonts and structure them
into collections -- or what I call "pogs" -- a place
to keep tyPOGraphy. Well, why not?

Your fonts never move from where they are
(so don't worry). All that happens is that you select 
fonts visually and place their names into a pog,
then you install or uninstall pogs as you need them.
No copies of your fonts are made, only links to the
original files are used to install the fonts.

For example, you might have a pog called "logos"
into which you place all the ttfs you have of
company logos. After that, when you need to work
with those logos, you simply install the 'logos' pog
and start your design app!

FP is also great for just looking at fonts wherever
they are on your computer, without having to install
them system-wide.
    
    Copyright (C) 2006, 2007, 2008 Donn.C.Ingle
    donn.ingle@gmail.com""",
    classifiers=[
      'Development Status :: 4 - Beta',
      'Environment :: X11 Applications :: GTK',
      'Intended Audience :: End Users/Desktop',
      'Intended Audience :: Developers',
      'License :: OSI Approved :: GNU General Public License (GPL)',
      'Operating System :: POSIX :: Linux',
      'Programming Language :: Python',
      'Topic :: Desktop Environment',
      'Topic :: Text Processing :: Fonts'
      ]    
) 

