<?php

 if (!defined("BELTANE")) {
	exit("This is an include file");
 }

 class YuleClient {
     var $type = 'client';
     var $client_host;           // host name
     var $client_os_machine;     // host architecture
     var $client_install_status; // client status
     var $client_install_date;   // client installation data
     var $client_install_name;   // client name
     var $client_install_prefix; // client location
     
     function YuleClient ($aa) {
        foreach ($aa as $k=>$v)
        	     $this->$k = $aa[$k];

     }
 }

 Class DataBase {
	var $Config = NULL;
	var $db     = NULL;

	// The constructor
	function DataBase () {

     	  $this->Config = new BeltaneConfig;
     	  $this->db = $this->readDatabase($this->Config->get_data_file());
     	  // print_r($this->db);
          // $this->writeDatabase($db);
   	}

	// Return database to caller
	//
        function get_data_base () {
		return $this->db;
	}

 function addClient($client) {
	if (!isset($this->db[$client["client_host"]])) {
		$this->db[$client["client_host"]] = new YuleClient($client);
	        return 0;
	}
	return 1;
 }

 function editClient($client) {
	$testnum = $client["client_host"];
	if (isset($this->db[$testnum])) {
		$this->db[$testnum]->client_os_machine = $client["client_os_machine"];
		$this->db[$testnum]->client_install_date = $client["client_install_date"];
		$this->db[$testnum]->client_install_name = $client["client_install_name"];
		$this->db[$testnum]->client_install_prefix = $client["client_install_prefix"];
	        return 0;
	}
	return 1;
 }

 function delClient($client) {
	if (isset($this->db[$client])) {
		unset($this->db[$client]);
		return 0;
   	}
	return 1;
 }

 function readDatabase($filename) {
     // read the xml database of clients


     if (!file_exists($filename)) {
	$this->writeDummyDatabase();
     }

     $data = implode("",file($filename));
     $parser = xml_parser_create();
     xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
     xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,1);
     xml_parse_into_struct($parser,$data,$values,$tags);
     xml_parser_free($parser);

     // loop through the structures
     foreach ($tags as $key=>$val) {
         if ($key == "client") {
             $clientranges = $val;
             // each contiguous pair of array entries are the 
             // lower and upper range for each client definition
             for ($i=0; $i < count($clientranges); $i+=2) {
                 $offset = $clientranges[$i] + 1;
                 $len = $clientranges[$i + 1] - $offset;
                 $tmp = $this->parseClient(array_slice($values, $offset, $len));
		 $tdb[$tmp->client_host] = $tmp;
             }
         } else {
             continue;
         }
     }
     return $tdb;
 }
 
 function parseClient($mvalues) {
     for ($i=0; $i < count($mvalues); $i++)
         $client[$mvalues[$i]["tag"]] = $mvalues[$i]["value"];
     return new YuleClient($client);
 }

 function writeDummyDatabase() {
 
   $file = $this->Config->get_data_file();
   $fp = fopen($file, "w");
   if ($fp == FALSE) 
	trigger_error("db::writeDatabase: error opening tmpfile", E_USER_ERROR);
   fputs ($fp, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
   fputs ($fp, "<!DOCTYPE yule_db SYSTEM \"http://la-samhna.de/yule_db-0.1.dtd\">\n");
   fputs ($fp, "<yule_db>\n");
   fputs ($fp, "  <client>\n");
   fputs ($fp, "    <client_host>DUMMY</client_host>\n");
   fputs ($fp, "    <client_os_machine>buildOS</client_os_machine>\n");
   fputs ($fp, "    <client_install_status>installed</client_install_status>\n");
   fputs ($fp, "    <client_install_date>INSTALL_DATE</client_install_date>\n");
   fputs ($fp, "    <client_install_name>INSTALL_NAME</client_install_name>\n");
   fputs ($fp, "    <client_install_prefix>INSTALL_PREFIX</client_install_prefix>\n");
   fputs ($fp, "  </client>\n");
   fputs ($fp, "</yule_db>\n");
   fclose($fp);
 }

 function writeDatabase() {
 
   $ddir = $this->Config->get_data_dir() . "/profiles";
   $newfile = tempnam ($ddir, "TMPFIL");
   $fp = fopen($newfile, "w");
   if ($fp == FALSE) 
	trigger_error("db::writeDatabase: error opening tmpfile", E_USER_ERROR);
   fputs ($fp, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
   fputs ($fp, "<!DOCTYPE yule_db SYSTEM \"http://la-samhna.de/yule_db-0.1.dtd\">\n");
   fputs ($fp, "<yule_db>\n");
   foreach ($this->db as $key => $value) {
       fputs ($fp, "  <$value->type>\n");
       foreach ($value as $key=>$val) {
	   if ($key != "type")
             fputs ($fp, "    <$key>$val</$key>\n");
       }
       fputs ($fp, "  </$value->type>\n");
   }
   fputs ($fp, "</yule_db>\n");
   fclose($fp);
   $tmptest = $this->Config->get_cp_com();
   if (!is_executable($tmptest)) {
	print("<p><b>ERROR:</b> \n");
	print("Command $tmptest is not executable\n");
	print("</p>\n");
	return 1;
   }

   
   $command = $this->Config->get_cp_com() . " " . $newfile;
   $command .=  " 2>&1";

   $result  = exec($command, $xarr, $ival);
   if ($ival != 0) {
	print("<p><b>ERROR:</b><br /> \n");
	$tmp = count($xarr);
	for ($itmp = 0; $itmp < $tmp; ++$itmp) {
		print("$xarr[$itmp]<br />\n");
	}
	print("</p>\n");
	return 1;
   }
   
   return 0;
 }

 }

 ?>
