<?php

 if (!defined("BELTANE")) {
        exit("This is an include file");
 }

 // MySQL and PostgreSQL: 
 // SELECT * FROM log WHERE log_host LIKE 'x%' ORDER BY log_index DESC LIMIT 1;

 // PostgreSQL and ANSI SQL: sub-select
 // SELECT * FROM log WHERE log_host LIKE 'x%' and 
 //           log_index = (SELECT MAX(log_index) FROM log);

 // actually, the "ORDER BY log_index DESC LIMIT 1" might be faster

 Class SqlQuery {

 var  $like_host = "";
 var  $items     = "";
 var  $link      = NULL;
 var  $use_pg    = FALSE;

 // The constructor
 function SqlQuery () {
   return 0;
 }

 function sql_setLikehost($prehost) {
    $host = addslashes($prehost);
    $this->like_host = "LIKE '${host}%' and";
 }

 function sql_unsetLikehost($host) {
    $this->like_host = "";
 }

 function sql_getindex($preindex) {
    global $Config;
    $pretable = $Config->get_table();

    $table = addslashes($pretable);
    $index = (int) $preindex;

    $query = "SELECT * FROM $table WHERE log_index = $index";

    if ($this->use_pg == TRUE) {
	$result = pg_exec($this->link, $query);
    } else {
        $result = mysql_query($query);
    }
    if (!$result) {
      print("<tr><td>");
      if ($this->use_pg == TRUE) {
	print(pg_errormessage($this->link));
      } else {
        print(mysql_error());
      }
      print("</td></tr>");
      return FALSE;
    }

    if ($this->use_pg == TRUE) {
	$num_rows = pg_numrows($result);
    } else {
        $num_rows = mysql_num_rows($result);
    }
    if ($num_rows == 0) { 
      print("<tr><td>");
      print("Row $index not found in database\n");
      print("</td></tr>");
      if ($this->use_pg == TRUE) {
	pg_freeresult($result);
      } else {
        mysql_free_result($result);
      }
      return FALSE; 
    }

    if ($this->use_pg == TRUE) {
      $row = pg_fetch_array($result, 0, PGSQL_ASSOC);
      pg_freeresult($result);
    } else {
      $row = mysql_fetch_array($result, MYSQL_ASSOC);
      mysql_free_result($result);
    }
    return $row;
  }

 function sql_getclient($myclient) {
	// addslashes is in messages.cgi
	return $this->sql_getmessages_int($myclient);
 }

 function sql_getmessages() {
	return $this->sql_getmessages_int("");
 }

 function sql_getmessages_int($myclient) {
    global $Config;

    $pretable = $Config->get_table();
    $table    = addslashes($pretable);

    if ($myclient == "") {
    $query = "SELECT log_index,log_host,log_time,log_sev,log_msg,entry_status,path FROM $table WHERE log_ref IS NULL and entry_status != 'ACK' and entry_status != 'ACK_AUTO' ORDER BY log_index";
    } else {
    $query = "SELECT log_index,log_host,log_time,log_sev,log_msg,entry_status,path FROM $table WHERE log_ref IS NULL and entry_status != 'ACK' and entry_status != 'ACK_AUTO' and log_host = '$myclient' ORDER BY log_index";
    }

    if ($this->use_pg == TRUE) {
	$result = pg_exec($this->link, $query);
    } else {
        $result = mysql_query($query);
    }
    if (!$result) {
      print("<tr><td>");
      if ($this->use_pg == TRUE) {
	print("SELECT: " + pg_errormessage($this->link));
      } else {
        print("SELECT: " + mysql_error());
      }
      print("</td></tr>");
      return FALSE;
    }

    if ($this->use_pg == TRUE) {
	$num_rows = pg_numrows($result);
    } else {
        $num_rows = mysql_num_rows($result);
    }
    if ($num_rows == 0) { 
      print("<tr><td>\n");
      if ($myclient == "") {
        print("No data in database\n");
      } else {
	$tmp = htmlspecialchars($myclient);
        print("No data in database for $tmp\n");
      }
      print("</td></tr>");
      if ($this->use_pg == TRUE) {
	pg_freeresult($result);
      } else {
        mysql_free_result($result);
      }
      return FALSE; 
    }

    unset($trow);
    $count = 0;
    if ($this->use_pg == TRUE) {
      while ($row = pg_fetch_object($result, $count, PGSQL_BOTH)) {
	$trow[$count] = $row;
	++$count;
	if ($count == $num_rows) { break; }
      }    
    } else {
      while ($row = mysql_fetch_object($result, MYSQL_BOTH)) {
	$trow[$count] = $row;
	++$count;
      }    
    }

    if ($this->use_pg == TRUE) {
      pg_freeresult($result);
    } else {
      mysql_free_result($result);
    }
    return $trow;
  }

 function sql_setack($preindex, $flag) {
    global $Config;

    $pretable = $Config->get_table();

    $table = addslashes($pretable);
    $index = (int) $preindex;

    if ($index >= 0 ) {
      if ($flag == TRUE) {
        $query = "UPDATE $table SET entry_status = 'ACK' WHERE log_index = $index";
      } else {
        $query = "UPDATE $table SET entry_status = 'NEW' WHERE log_index = $index";
      }

      if ($this->use_pg == TRUE) {
        if (FALSE == pg_exec($this->link, $query)) {
          print("<tr><td>");
          print(pg_errormessage($this->link));
          print("</td></tr>");
          return FALSE;
        }
      } else {
        if (FALSE == mysql_query($query)) {
          print("<tr><td>");
          print(mysql_error());
          print("</td></tr>");
          return FALSE;
        }
      }
      return TRUE;
    }
    return FALSE;    
 }

 function ret_sev($a) { 
   if ($a == "ALRT")
	return 7;
   if ($a == "CRIT")
	return 6;
   if ($a == "ERRO")
	return 5;
   if ($a == "WARN")
	return 4;
   if ($a == "MARK")
	return 3;
   if ($a == "NOTE")
	return 2;
   if ($a == "INFO")
	return 1;
   return 0;
 }

 function cmp_sev ($a, $b) { 
   $x = array( 'ALRT' => 7
        , 'CRIT' => 6
        , 'ERRO' => 5
        , 'WARN' => 4
        , 'MARK' => 3
        , 'NOTE' => 2
        , 'INFO' => 1
        , 'DEBG' => 0
        );
   $xa = $a->log_sev;
   $xb = $b->log_sev;
 
   if ($x[$xa] == $x[$xb]) {
     return ($a->log_index > $b->log_index) ? -1 : 1;
   }
   return ($x[$xa] > $x[$xb]) ? -1 : 1;
 }

 function sql_queryClient($preclient, $useLike, &$index) {
    global $Config;

    $pretable = $Config->get_table();

    $client = addslashes($preclient);
    $table  = addslashes($pretable);

    // old: DESC LIMIT 1 atend

    if ($useLike == 1) {
      $query = "SELECT log_index,log_hash,log_sev,log_msg,entry_status FROM $table WHERE log_host LIKE '${client}%' and entry_status = 'NEW' and log_ref IS NULL ORDER BY log_index";
    }
    else {
      $query = "SELECT log_index,log_hash,log_sev,log_msg,entry_status FROM $table WHERE log_host = '${client}' and entry_status = 'NEW' and log_ref IS NULL ORDER BY log_index";
    }

    if ($this->use_pg == TRUE) {
	$result = pg_exec($this->link, $query);
    } else {
        $result = mysql_query($query);
    }
    if (!$result) {
      print("<tr><td>");
      if ($this->use_pg == TRUE) {
	print(pg_errormessage($this->link));
      } else {
        print(mysql_error());
      }
      print("</td></tr>");
      return FALSE;
    }

    if ($this->use_pg == TRUE) {
	$num_rows = pg_numrows($result);
    } else {
        $num_rows = mysql_num_rows($result);
    }
    if ($num_rows == 0) { return 0; }

    // new
    unset($trow);
    $count = 0;
    if ($this->use_pg == TRUE) {
      while ($row = pg_fetch_object($result, $count, PGSQL_BOTH)) {
	$trow[$count] = $row;
	++$count;
        if ($count == $num_rows) { break; }
      }    
    } else {
      while ($row = mysql_fetch_object($result, MYSQL_BOTH)) {
	$trow[$count] = $row;
	++$count;
      }    
    }

    // Sort rows by severity

    $xi = $count - 1;
    $maxrow = $trow[$xi];
    --$xi;
    while ($xi >= 0) {
	$row = $trow[$xi];
	if ($this->ret_sev($row->log_sev) > $this->ret_sev($maxrow->log_sev)) {
		$maxrow = $row;
	}
	--$xi;
    }
    $row = $maxrow;

    // usort($trow, "cmp_sev");
    // $row =  $trow[0];

    $index  = $row->log_index;
    $retval = $this->sql_Sevtoint($row->log_sev, $row->entry_status);
    return $retval;
  }



  function sql_Sevtoint($log_sev, $entry_status) {

    if ($log_sev == "DEBG" || $log_sev == "INFO" || 
	$log_sev == "NOTE" || $log_sev == "MARK" ||
        $entry_status == "ACK") {
       return 1;
    }
    if ($log_sev == "WARN") {
       return 2;
    }
    if ($log_sev == "ERRO") {
       return 3;
    }
    if ($log_sev == "CRIT") {
       return 4;
    }
    if ($log_sev == "ALRT") {
       return 5;
    }
    return 0;
 }

 function sql_connect() {
    global $Config;

    $this->use_pg = $Config->get_postgres();

    if ($this->use_pg == TRUE) {
      $x_host = $Config->get_host();
      $x_user = $Config->get_user();
      $x_pass = $Config->get_password();
      $x_name = $Config->get_database();
      $x_conn = "user=" . $x_user . " dbname=" . $x_name;
      if ($x_host != "") { $x_conn .= " host=" . $x_host; }
      if ($x_pass != "") { $x_conn .= " password="; $x_conn .= $x_pass; }
      $this->link = pg_connect($x_conn);
    } else {
      $this->link = mysql_connect($Config->get_host(), $Config->get_user(), 
                          $Config->get_password());
    }

    if (!$this->link) {
     if ($this->use_pg == TRUE) {
     	print("Could not connect to PostgreSQL database: $x_conn");
     } else {
	$x_conn = "host="; $x_conn  .= $Config->get_host(); 
	$x_conn .= " user=";
	$x_conn .= $Config->get_user(); 
	$x_conn .= " password=";
	$x_conn .= $Config->get_password();
     	print("Could not connect to MySQL database: $x_conn");
     }
     return 1;
    }
    // print "Connected successfully";
    if ($this->use_pg != TRUE) {
      $tmp = mysql_select_db($Config->get_database());
      if (!$tmp) {
        print("Could not select database");
        return 1;
      }
    }
    return 0;
 }
 function sql_disconnect() {
    if ($this->use_pg == TRUE) {
      pg_close($this->link);
    } else {
      mysql_close($this->link);
    }
 }

 /* Auto-ack: should be possible with a sub-select like:

    UPDATE $table SET entry_status = 'ACK_AUTO' WHERE entry_status = 'NEW' AND
     log_hash IN (SELECT log_hash FROM $table WHERE entry_status = 'ACK_TMPL');
 */

 /* This function takes an array of sql table rows (in OBJECT format),
    checks which of them should be auto-acknowleged, and updates the table
 */
 function auto_ack($all_rows) {
   global $Config;

   if ($Config->get_auto_ack() == "TRUE") {
	return 0;
   }

   $table = $Config->get_table();

   $count = 0;
   while ($row = $all_rows[$count]) {
     // AUTO_ACK
     if ($row->entry_status == "NEW") {
       $query = "SELECT log_index FROM $table WHERE log_hash = '$row->log_hash' and entry_status = 'ACK' LIMIT 1";

       if ($this->use_pg == TRUE) {
         $result = pg_exec($this->link, $query);
       } else {
         $result = mysql_query($query);
       }
       if (!$result) {
         if ($this->use_pg == TRUE) {
           print(pg_errormessage($this->link));
         } else {
           print(mysql_error());
         }
       } else {
         if ($this->use_pg == TRUE) {
           if (0 != pg_numrows($result)) {
	     $row->entry_status = "ACK";
             $query = "UPDATE $table SET entry_status = 'ACK_AUTO' WHERE log_index = $row->log_index";
             pg_freeresult($result);
             $result = pg_exec($this->link, $query);
             if (!$result) {
               print(pg_errormessage());
             }
           }
         
         } else {

           if (0 != mysql_num_rows($result)) {
	     $row->entry_status = "ACK";
             $query = "UPDATE $table SET entry_status = 'ACK_AUTO' WHERE log_index = $row->log_index";
             mysql_free($result);
             $result = mysql_query($query);
             if (!$result) {
               print(mysql_error());
             }
           }
         }
       }
     }
     // END AUTO_ACK
   }
 }
 
 }
?>
