/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "effectportframe.h"

EffectPortFrame::EffectPortFrame(QString _name,LADSPAPort* _port,QWidget *parent, const char *name)
 : QCanvasView(parent, name)
{
    enableClipper(TRUE);
    zoomRatio=1;
    name=_name;
    port=_port;
    c_height=100;
    linesCreated=FALSE;
    setGeometry(((QVBox*)parent)->contentsRect());
    canvas=new ControllerCanvas(viewport());
    canvas->setBackgroundColor(green);
    setCanvas(canvas);


    canvas->resize(((QVBox*)parent)->contentsRect().width(),c_height);
    canvas->update();
    drawValueLines();
    setVScrollBarMode(AlwaysOff);
    setHScrollBarMode(AlwaysOff);
    drawing=FALSE;
    startDrawingPosition=0;
    endDrawingPosition=0;
    applyPolicy=NO_AUTO_APPLY;
    drawMode=DRAW_MODE_POINTS;

    drawingLine=new DrawingLine(canvas);

}


EffectPortFrame::~EffectPortFrame()
{

}

void EffectPortFrame::raiseMe(){
    ((QWidgetStack*)parent())->raiseWidget(this);
    canvas->resize(contentsRect().width(),c_height);
    drawValueLines();

    //std::cout<<"i'm raised!: "<<port->getPortName()<<"\n";
}


/*!
    \fn EffectPortFrame::resizeEvent(QResizeEvent*)
 */
void EffectPortFrame::resizeEvent(QResizeEvent* ev)
{
    QCanvasView::resizeEvent(ev);
    canvas->resize((int)((double)port->getNbFrames()/(double)zoomRatio),
                                            c_height);
    drawValueLines();
    canvas->update();
}

void EffectPortFrame::drawValueLines(){
    float max=port->getUpperBound();
    float min=port->getLowerBound();
    float diff=max-min;

    if(!linesCreated){
        for (double i=0;i<port->getNbFrames();i+=1024){
                ValueLine* line=new ValueLine(canvas,(long)i,(float*)port->getVOTPointer((int)i/1024));
                int drawValue=(int)(c_height-((line->getValue()-min)*c_height)/diff);
                line->setPen(blue);
                line->setPoints((int)(i/zoomRatio),drawValue,(int)(i/zoomRatio),c_height);
                line->show();
        }
        linesCreated=TRUE;
    }else{
        QCanvasItemList l=canvas->allItems();
        for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
            ValueLine* templine=(ValueLine*)(*it);
            if (templine->isVisible()){
                templine->setPoints(templine->getSamplePos()/zoomRatio,
                                                 templine->startPoint().y(),
                                                 templine->getSamplePos()/zoomRatio,
                                                 c_height);
            }
        }
    }
    canvas->update();
}

/*!
    \fn EffectPortFrame::repaintEvent(QPaintEvent*)
 */
void EffectPortFrame::paintEvent(QPaintEvent*)
{
    //canvas->resize(visibleWidth(),visibleHeight());
    //drawValueLines();
    /*
    canvas->resize((int)(port->getNbFrames()/zoomRatio),
                                            c_height);
    */
    //canvas->update();
}

void EffectPortFrame::closeEvent( QCloseEvent* ce ){

    //delete canvas;
    ce->accept();
}



/*!
    \fn EffectPortFrame::setZoomRatio(long)
 */
void EffectPortFrame::setZoomRatio(long _zr)
{
    zoomRatio=_zr;
    canvas->resize((int)((double)port->getNbFrames()/(double)zoomRatio),c_height);
    drawValueLines();
    repaint();
}


/*!
    \fn EffectPortFrame::getZoomRatio
 */
long EffectPortFrame::getZoomRatio()
{
    return zoomRatio;
}


/*!
    \fn EffectPortFrame::getCanvas()
 */
ControllerCanvas* EffectPortFrame::getCanvas()
{
    return canvas;
}

void EffectPortFrame::contentsMousePressEvent( QMouseEvent * mouseEvent){
    QPoint pos=mouseEvent->pos();
    pos.setX(pos.x()<0?0:pos.x());
        startDrawingPosition=pos.x()*zoomRatio;
        startDrawingPosition=startDrawingPosition>port->getNbFrames()?
                                         port->getNbFrames():startDrawingPosition;
    if(drawMode==DRAW_MODE_LINES){
        drawingLine->setStartPoint(pos.x(),pos.y());
        drawingLine->setEndPoint(pos.x(),pos.y());
        drawingLine->show();
        canvas->update();
        drawing=TRUE;
    }else if(drawMode==DRAW_MODE_POINTS){
        if (mouseEvent->button()==LeftButton||mouseEvent->button()==RightButton){
            if(mouseEvent->button()==RightButton){
                startDrawingPosition=0;
            }
            updateValueAtPos(pos,mouseEvent->button()==LeftButton,mouseEvent->button()==RightButton);
            drawing=TRUE;
            if(applyPolicy==APPLY_ON_CHANGE){
                if(mouseEvent->state()==LeftButton){
                    int startx=pos.x()*zoomRatio-1024*2;
                    int endx=pos.x()*zoomRatio+1024*2;
                    startx=startx<0?0:startx;
                    endx=endx>port->getNbFrames()?port->getNbFrames():endx;
                    emit(valueChanged(startx,endx));
                }else if(mouseEvent->state()==RightButton){
                    emit(valueChanged(0,port->getNbFrames()));
                }
            }
        }
    }
}

void EffectPortFrame::contentsMouseMoveEvent( QMouseEvent * mouseEvent){
    if(drawMode==DRAW_MODE_LINES){
        if(drawing){
            QPoint pos=mouseEvent->pos();
            drawingLine->setEndPoint(pos.x(),pos.y());
            canvas->update();
        }
    }else if(drawMode==DRAW_MODE_POINTS){
        if(mouseEvent->state()==LeftButton ||mouseEvent->state()==RightButton){
            QPoint pos=mouseEvent->pos();
            pos.setX(pos.x()<0?0:pos.x());
            if(drawing){
                updateValueAtPos(pos,mouseEvent->state()==LeftButton,mouseEvent->state()==RightButton);
                if(applyPolicy==APPLY_ON_CHANGE){
                    if(mouseEvent->state()==LeftButton){
                        int startx=pos.x()*zoomRatio-1024*2;
                        int endx=pos.x()*zoomRatio+1024*2;
                        startx=startx<0?0:startx;
                        endx=endx>port->getNbFrames()?port->getNbFrames():endx;
                        emit(valueChanged(startx,endx));
                    }else if(mouseEvent->state()==RightButton){
                        emit(valueChanged(0,port->getNbFrames()));
                    }
                }
            }
        }
    }
}

void EffectPortFrame::contentsMouseReleaseEvent( QMouseEvent * mouseEvent){
    QPoint pos=mouseEvent->pos();
    pos.setX(pos.x()<0?0:pos.x()>width()?width():pos.x());
     endDrawingPosition=pos.x()*zoomRatio;
    endDrawingPosition=endDrawingPosition>port->getNbFrames()?
                                                            port->getNbFrames():endDrawingPosition;
    if(drawMode==DRAW_MODE_LINES){
        if(drawing){
            QCanvasItemList collisions=canvas->collisions(drawingLine->boundingRect());
            if(!collisions.isEmpty()){
                    QCanvasItemList::iterator it;
                    for ( it = collisions.begin(); it != collisions.end(); ++it ){
                            if((*it)->rtti()==ValueLine::RTTI){
                                ValueLine* temp=(ValueLine*)(*it);
                                float max=port->getUpperBound();
                                float min=port->getLowerBound();
                                float diff=max-min;
                                int y=drawingLine->getYAtX(temp->startPoint().x());
                                if(y>c_height) y=c_height;
                                if(y<0) y=0;
                                 float controlerValue=(((c_height-y)*diff)/c_height)+min;
                                 *(temp->getValuePointer())=controlerValue;
                                 temp->setPoints(temp->startPoint().x(),y,temp->endPoint().x(),c_height);
                            }
                    }
            }
            drawingLine->hide();
            canvas->update();
            if(applyPolicy==APPLY_ON_RELEASE){
                if(startDrawingPosition<endDrawingPosition)
                    emit(valueChanged(startDrawingPosition,endDrawingPosition));
                else
                    emit(valueChanged(endDrawingPosition,startDrawingPosition));
            }
            drawing=FALSE;
        }
    }else if(drawMode==DRAW_MODE_POINTS){
        if(drawing){
           if(mouseEvent->state()==RightButton){
                endDrawingPosition=port->getNbFrames();
            }
            drawing=FALSE;
            if(applyPolicy==APPLY_ON_RELEASE){
                if(startDrawingPosition<endDrawingPosition)
                    emit(valueChanged(startDrawingPosition,endDrawingPosition));
                else
                    emit(valueChanged(endDrawingPosition,startDrawingPosition));
            }
        }
    }
}

void EffectPortFrame::contentsWheelEvent( QWheelEvent *){
}

void EffectPortFrame::updateValueAtPos(QPoint pos,bool leftButton,bool rightButton){
        float max=port->getUpperBound();
        float min=port->getLowerBound();
        float diff=max-min;
        int x=pos.x();
        if(x<0) x=0;
        int y=pos.y();
        if(y>c_height) y=c_height;
        if(y<0) y=0;
        QRect rect(x-2,0,4,c_height);
        QCanvasItemList colisions;
        if(leftButton)
            colisions=canvas->collisions(rect);
        else if(rightButton)
            colisions=canvas->allItems();
        if(!colisions.isEmpty()){
                float controlerValue=(((c_height-y)*diff)/c_height)+min;
                //std::cout<<"cv: "<<controlerValue<<"\n";
                for (QCanvasItemList::Iterator it=colisions.begin(); it!=colisions.end(); ++it) {
                    if((*it)->rtti()==ValueLine::RTTI){
                        ValueLine* temp=(ValueLine*)(*it);
                        *(temp->getValuePointer())=controlerValue;
                        temp->setPoints(temp->startPoint().x(),y,temp->endPoint().x(),c_height);
                    }
                }
                canvas->update();
        }
}


/*!
    \fn EffectPortFrame::setApplyPolicy()
 */
void EffectPortFrame::setApplyPolicy(int pol)
{
    applyPolicy=pol;
}

void EffectPortFrame::linesToggled(bool tog)
{
    if(tog) drawMode=DRAW_MODE_LINES;
    else drawMode=DRAW_MODE_POINTS;
}
