/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "displayenvelopewidget.h"
#include <qpixmap.h>
#include <qpainter.h>
#include "mymath.h"
#include "envelopedata.h"

DisplayEnvelopeWidget::DisplayEnvelopeWidget(QWidget *parent, const char *name)
 : QLabel(parent, name,WNoAutoErase)
{
    attack=0;
    hold=0;
    decay=0;
    release=0;
    sustain=100;
    qattack=50;
    qhold=50;
    qdecay=50;
    qrelease=50;
    qsustain=50;

    computeRects();
}


DisplayEnvelopeWidget::~DisplayEnvelopeWidget()
{
}

void DisplayEnvelopeWidget::drawContents ( QPainter * p){
    static QPixmap pixmap;
    int sustainPos=MyMath::linear_regression(0,100,sustainRect.bottom(),sustainRect.top(),sustain);
    if(contentsRect().size().isValid()){
        pixmap.resize(contentsRect().size());
        QPainter p2(&pixmap);
        p2.fillRect(contentsRect(),black);
        p2.setPen(QPen(gray,1,Qt::DotLine));
        p2.drawText(attackRect,Qt::AlignHCenter|Qt::AlignVCenter,"A");
        p2.drawText(holdRect,Qt::AlignHCenter|Qt::AlignVCenter,"H");
        p2.drawText(decayRect,Qt::AlignHCenter|Qt::AlignVCenter,"D");
        p2.drawText(sustainRect,Qt::AlignHCenter|Qt::AlignVCenter,"S");
        p2.drawText(releaseRect,Qt::AlignHCenter|Qt::AlignVCenter,"R");


        p2.drawLine(attackRect.right(),contentsRect().top(),
                                attackRect.right(),contentsRect().bottom());
        p2.drawLine(holdRect.right(),contentsRect().top(),
                    holdRect.right(),contentsRect().bottom());
        p2.drawLine(decayRect.right(),contentsRect().top(),
                    decayRect.right(),contentsRect().bottom());
        p2.drawLine(sustainRect.right(),contentsRect().top(),
                    sustainRect.right(),contentsRect().bottom());

        p2.drawLine(contentsRect().x(),sustainPos,contentsRect().x()+contentsRect().width(),sustainPos);
        p2.setPen(QPen(QColor(150,150,255),5,Qt::SolidLine));
        drawNonLinearSegment(&p2,attackRect.bottomLeft(),attackRect.topRight(),qattack);
        drawNonLinearSegment(&p2,holdRect.topLeft(),holdRect.topRight(),qhold);
        drawNonLinearSegment(&p2,decayRect.topLeft(),QPoint(decayRect.topRight().x(),sustainPos),
                                                    qdecay);
        drawNonLinearSegment(&p2,QPoint(sustainRect.topLeft().x(),sustainPos),
                              QPoint(sustainRect.topRight().x(),sustainPos),qsustain);
        drawNonLinearSegment(&p2,QPoint(releaseRect.topLeft().x(),sustainPos),
                                                    releaseRect.bottomRight(),qrelease);
        p->drawPixmap(0,0,pixmap);
        //bitBlt(this,contentsRect().topLeft(),&pixmap);
    }
}




/*!
    \fn DisplayEnvelopeWidget::setS(int s)
 */
void DisplayEnvelopeWidget::setS(int s)
{
    sustain=s;
    computeRects();
    update();
}

/*!
    \fn DisplayEnvelopeWidget::setH(int h)
 */
void DisplayEnvelopeWidget::setH(int h)
{
    hold=h;
    computeRects();
    update();
}



/*!
    \fn DisplayEnvelopeWidget::setA(int a)
 */
void DisplayEnvelopeWidget::setA(int a)
{
    int w=contentsRect().width();
    attack=a;
    int attackWidth=(attack*w)/100;
    int decayWidth=(decay*w)/100;
    int releaseWidth=(release*w)/100;
    if(attackWidth+decayWidth+releaseWidth>w){
        if(release>0){
            setR(((w-attackWidth-decayWidth)*100)/w);
            emit(releaseChanged(release));
        }else{
            setD(((w-attackWidth-releaseWidth)*100)/w);
            emit(decayChanged(decay));
        }
    }
    computeRects();
    update();
}


/*!
    \fn DisplayEnvelopeWidget::setD(int d)
 */
void DisplayEnvelopeWidget::setD(int d)
{
    decay=d;
    int w=contentsRect().width();
    int attackWidth=(attack*w)/100;
    int decayWidth=(decay*w)/100;
    int releaseWidth=(release*w)/100;
    if(attackWidth+decayWidth+releaseWidth>w){
            setR(((w-attackWidth-decayWidth)*100)/w);
            emit(releaseChanged(release));
    }
    computeRects();
    update();
}


/*!
    \fn DisplayEnvelopeWidget::setR(int r)
 */
void DisplayEnvelopeWidget::setR(int r)
{
    release=r;
    computeRects();
    update();
}

/*!
    \fn DisplayEnvelopeWidget::setQA(int qa)
 */
void DisplayEnvelopeWidget::setQA(int qa)
{
    qattack=qa;
    update();
}

/*!
    \fn DisplayEnvelopeWidget::setQH(int qh)
 */
                void DisplayEnvelopeWidget::setQH(int qh)
{
    qhold=qh;
    update();
}

/*!
    \fn DisplayEnvelopeWidget::setQD(int qd)
 */
void DisplayEnvelopeWidget::setQD(int qd)
{
    qdecay=qd;
    update();
}
/*!
    \fn DisplayEnvelopeWidget::setQS(int qs)
 */
void DisplayEnvelopeWidget::setQS(int qs)
{
    qsustain=qs;
    update();
}
/*!
    \fn DisplayEnvelopeWidget::setQR(int qr)
 */
void DisplayEnvelopeWidget::setQR(int qr)
{
    qrelease=qr;
    update();
}

void DisplayEnvelopeWidget::resizeEvent ( QResizeEvent * ev ){
    resize(ev->size());
    computeRects();
}


/*!
    \fn DisplayEnvelopeWidget::computeRects()
 */
void DisplayEnvelopeWidget::computeRects()
{
    int w=contentsRect().width();
    QRect drawRect=contentsRect();
    drawRect.setTop(5);
    drawRect.setBottom(contentsRect().height()-5);

    int attackWidth=(attack*w)/100;
    int holdWidth=(hold*(w-attackWidth))/100;
    int decayWidth=(decay*(w-attackWidth-holdWidth))/100;
    int releaseWidth=(release*(w-attackWidth-holdWidth-decayWidth))/100;
    int sustainWidth=w-attackWidth-holdWidth-decayWidth-releaseWidth;
    attackRect.setRect(drawRect.x(),drawRect.y(),attackWidth,drawRect.height());
    holdRect.setRect(attackRect.right(),drawRect.y(),holdWidth,drawRect.height());
    decayRect.setRect(holdRect.right(),drawRect.y(),decayWidth,drawRect.height());
    sustainRect.setRect(decayRect.right(),drawRect.y(),sustainWidth,drawRect.height());
    releaseRect.setRect(sustainRect.right(),drawRect.y(),releaseWidth,drawRect.height());
}


/*!
    \fn DisplayEnvelopeWidget::drawNonLinearSegment(QPainter p,QPoint start, QPoint end,int q)
 */
void DisplayEnvelopeWidget::drawNonLinearSegment(QPainter* p,QPoint start, QPoint end,int q)
{
    int height=abs(start.y()-end.y());
    int width=abs(start.x()-end.x());
    float normalizedq=q;
    int medianq=50;
    if (start.y()<end.y()){
        //  -(x^n) -x^(1/n)
        if(normalizedq<medianq){
            float max=pow(width ,1/(medianq-normalizedq));
            for (float x=start.x();x<end.x();x+=0.01){
                float y=-pow((x-start.x()) ,1/(medianq-normalizedq));
                //normalize to height
                y=(y*height)/max;
                drawThickPoint(p,QPoint(x,start.y()-y));
            }
        }else{
            float max=pow(width,normalizedq-medianq+1);
            for (float x=start.x();x<end.x();x+=0.01){
                float y=-pow((x-start.x()) ,normalizedq-medianq+1);
                //normalize to height
                y=(y*height)/max;
                drawThickPoint(p,QPoint(x,start.y()-y));
            }
        }
    }else if (start.y()>end.y()) {
        //  x^n  x^(1/n)
        if(normalizedq<medianq){
            float max=pow(width,1/(medianq-normalizedq));
            for (float x=start.x();x<end.x();x+=0.01){
                float y=pow(x-start.x(),1/(medianq-normalizedq));
                //normalize to height
                y=(y*height)/max;
                drawThickPoint(p,QPoint(x,start.y()-y));
            }
        }else{
            float max=pow(width,normalizedq-medianq+1);
            for (float x=start.x();x<end.x();x+=0.01){
                float y=pow(x-start.x(),normalizedq-medianq+1);
                //normalize to height
                y=(y*height)/max;
                drawThickPoint(p,QPoint(x,start.y()-y));
            }
        }
    }else{
        for (float x=start.x();x<end.x();x+=1){
            drawThickPoint(p,QPoint(x,start.y()));
        }
    }
}


/*!
    \fn DisplayEnvelopeWidget::drawThickPoint(QPainter* p,QPoint point)
 */
void DisplayEnvelopeWidget::drawThickPoint(QPainter* p,QPoint point)
{
    int x=point.x();
    int y=point.y();
    int width=p->pen().width();
    QColor tempPenColor=p->pen().color();
    QPen oldPen=p->pen();

    for (int i=-ceil(width/2);i<ceil(width/2);i++){
        int darkenFactor=MyMath::linear_regression(0,width/2,100,10,abs(i)); //basic antialiasing
        p->setPen(tempPenColor.light(darkenFactor));
        p->drawPoint(x,y+i);
    }
    p->setPen(oldPen);
}
