/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DISPLAYENVELOPEWIDGET_H
#define DISPLAYENVELOPEWIDGET_H

#include <qlabel.h>
#include <defs.h>

/**
@author Predrag Viceic
*/
class DisplayEnvelopeWidget : public QLabel
{
Q_OBJECT
public:
    DisplayEnvelopeWidget(QWidget *parent = 0, const char *name = 0);

    ~DisplayEnvelopeWidget();
    void drawNonLinearSegment(QPainter* p,QPoint start, QPoint end,int q);
    void drawThickPoint(QPainter* p,QPoint point);

public slots:
    void setA(int a);
    void setH(int h);
    void setD(int d);
    void setS(int s);
    void setR(int r);
    void setQA(int qa);
    void setQH(int qh);
    void setQD(int qd);
    void setQS(int qs);
    void setQR(int qr);


protected:
    int attack;
    int hold;
    int release;
    int decay;
    int sustain;
    int qattack;
    int qhold;
    int qrelease;
    int qdecay;
    int qsustain;
    QRect attackRect;
    QRect holdRect;
    QRect decayRect;
    QRect sustainRect;
    QRect releaseRect;
    void resizeEvent ( QResizeEvent * );
    void drawContents ( QPainter * );
private:
    void computeRects();
signals:
    void attackChanged(int a);
    void holdChanged(int h);
    void decayChanged(int d);
    void sustainChanged(int s);
    void releaseChanged(int r);
};

#endif
