/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "envelopecontrollerwidget.h"
#include "envelopedata.h"
#include <qstringlist.h>

EnvelopeControllerWidget::EnvelopeControllerWidget(QWidget *parent, const char *name)
 : QHBox(parent, name)
{

    inHolder=false;
    start_frame=0;
    end_frame=0;

    QHBox* knobs=new QHBox(this);
    QVBox* aKnobs=new QVBox(knobs);
    QVBox* hKnobs=new QVBox(knobs);
    QVBox* dKnobs=new QVBox(knobs);
    QVBox* sKnobs=new QVBox(knobs);
    QVBox* rKnobs=new QVBox(knobs);




    attackPotentiometer=new PotentiometerWidget(aKnobs);
    attackPotentiometer->setValue(0);
    holdPotentiometer=new PotentiometerWidget(hKnobs);
    holdPotentiometer->setValue(0);
    decayPotentiometer=new PotentiometerWidget(dKnobs);
    decayPotentiometer->setValue(0);
    sustainPotentiometer=new PotentiometerWidget(sKnobs);
    sustainPotentiometer->setValue(100);
    releasePotentiometer=new PotentiometerWidget(rKnobs);
    releasePotentiometer->setValue(0);

    attackQPotentiometer=new PotentiometerWidget(aKnobs);
    attackQPotentiometer->setValue(50);
    holdQPotentiometer=new PotentiometerWidget(hKnobs);
    holdQPotentiometer->setValue(0);
    holdQPotentiometer->setEnabled(false);
    decayQPotentiometer=new PotentiometerWidget(dKnobs);
    decayQPotentiometer->setValue(50);
    sustainQPotentiometer=new PotentiometerWidget(sKnobs);
    sustainQPotentiometer->setValue(50);
    sustainQPotentiometer->setEnabled(false);
    releaseQPotentiometer=new PotentiometerWidget(rKnobs);
    releaseQPotentiometer->setValue(50);

    attackPotentiometer->setFixedSize(25,25);
    holdPotentiometer->setFixedSize(25,25);
    decayPotentiometer->setFixedSize(25,25);
    sustainPotentiometer->setFixedSize(25,25);
    releasePotentiometer->setFixedSize(25,25);
    attackQPotentiometer->setFixedSize(25,25);
    holdQPotentiometer->setFixedSize(25,25);
    decayQPotentiometer->setFixedSize(25,25);
    sustainQPotentiometer->setFixedSize(25,25);
    releaseQPotentiometer->setFixedSize(25,25);


    displayEnvelope=new DisplayEnvelopeWidget(this);
    displayEnvelope->setFixedWidth(150);
    displayEnvelope->setFixedHeight(48);
    displayEnvelope->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    displayEnvelope->setLineWidth(2);

    connect(attackPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setA(int )));
    connect(holdPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setH(int )));
    connect(decayPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setD(int )));
    connect(sustainPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setS(int)));
    connect(releasePotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setR(int)));
    connect(attackQPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setQA(int )));
    connect(holdQPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setQH(int )));
    connect(decayQPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setQD(int )));
    connect(sustainQPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setQS(int)));
    connect(releaseQPotentiometer,SIGNAL(valueChanged(int)),displayEnvelope,SLOT(setQR(int)));

    connect(attackPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(holdPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(decayPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(sustainPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(releasePotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(attackQPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(decayQPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(sustainQPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));
    connect(releaseQPotentiometer,SIGNAL(valueChanged(int)),this,SIGNAL(envelopeValueChanged()));

    connect(displayEnvelope,SIGNAL(attackChanged(int)),attackPotentiometer,SLOT(setValue(int)));
    connect(displayEnvelope,SIGNAL(holdChanged(int)),holdPotentiometer,SLOT(setValue(int)));
    connect(displayEnvelope,SIGNAL(decayChanged(int)),decayPotentiometer,SLOT(setValue(int)));
    connect(displayEnvelope,SIGNAL(releaseChanged(int)),releasePotentiometer,SLOT(setValue(int)));
}


EnvelopeControllerWidget::~EnvelopeControllerWidget()
{
}




/*!
    \fn EnvelopeControllerWidget::getEnvelopeValueAt(long x, long l_bound, long u_bound)
 */
double EnvelopeControllerWidget::getEnvelopeValueAt(long x, long l_bound, long u_bound)
{
    /// @todo implement me
}

void EnvelopeControllerWidget::mouseMoveEvent( QMouseEvent * ev){
    if(!inHolder){
        QRect rect=displayEnvelope->rect();
        rect.moveBy(displayEnvelope->pos().x(),displayEnvelope->pos().y());
        if(rect.contains(ev->pos())){
            QString data("exp,"+
                    QString::number(attackPotentiometer->value())+","+
                    QString::number(holdPotentiometer->value())+","+
                    QString::number(decayPotentiometer->value())+","+
                    QString::number(sustainPotentiometer->value())+","+
                    QString::number(releasePotentiometer->value())+","+
                    QString::number(attackQPotentiometer->value())+","+
                    QString::number(holdQPotentiometer->value())+","+
                    QString::number(decayQPotentiometer->value())+","+
                    QString::number(sustainQPotentiometer->value())+","+
                    QString::number(releaseQPotentiometer->value()));
            EnvelopeData *d = new EnvelopeData(data,this);
            d->setPixmap(QPixmap::grabWidget(this));
            d->dragCopy();
        }
    }
}


/*!
    \fn EnvelopeControllerWidget::setData(QString envData)
 */
void EnvelopeControllerWidget::setData(QString envData)
{
    cout<<"received data: "<<envData<<endl;
    QStringList list=QStringList::split(",",envData);
    attackPotentiometer->setValue(list[1].toInt());
    holdPotentiometer->setValue(list[2].toInt());
    decayPotentiometer->setValue(list[3].toInt());
    sustainPotentiometer->setValue(list[4].toInt());
    releasePotentiometer->setValue(list[5].toInt());
    attackQPotentiometer->setValue(list[6].toInt());
    holdQPotentiometer->setValue(list[7].toInt());
    decayQPotentiometer->setValue(list[8].toInt());
    sustainQPotentiometer->setValue(list[9].toInt());
    releaseQPotentiometer->setValue(list[10].toInt());
    update();
}


/*!
    \fn EnvelopeControllerWidget::setInHolder(bool)
 */
void EnvelopeControllerWidget::setInHolder(bool tf)
{
    inHolder=tf;
}


/*!
    \fn EnvelopeControllerWidget::getEndFrame()
 */
long EnvelopeControllerWidget::getEndFrame()
{
    return end_frame;
}


/*!
    \fn EnvelopeControllerWidget::getStartFrame()
 */
long EnvelopeControllerWidget::getStartFrame()
{
    return start_frame;
}


/*!
    \fn EnvelopeControllerWidget::setEndFrame(long ef)
 */
void EnvelopeControllerWidget::setEndFrame(long ef)
{
    end_frame=ef;
}


/*!
    \fn EnvelopeControllerWidget::setStartFrame(long sf)
 */
void EnvelopeControllerWidget::setStartFrame(long sf)
{
    start_frame=sf;
}
