/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CUSTOMEFFECTS_H
#define CUSTOMEFFECTS_H

#include <qobject.h>
#include <customeffect.h>
#include <qptrlist.h>
#include "defs.h"

/**
@author Predrag Viceic
*/
class CustomEffects : public QObject
{
Q_OBJECT
public:
    CustomEffects(QObject *parent = 0, const char *name = 0);

    ~CustomEffects();
    void processEffects(long length,int preOrPost);
    void initEffects(long length);
    void add(CustomEffect*);
    void advancePositions(long length);
    void clear();
    void setPositions(long position);
 private:
    QPtrList <CustomEffect> effects;

};

#endif
