/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bitspersampledropdown.h"

BitsPerSampleDropdown::BitsPerSampleDropdown(QWidget *parent, const char *name)
 : QComboBox(parent, name)
{
    insertItem("16 bit",0);
    insertItem("24 bit",1);
    insertItem("32 bit fp (internal)",2);
    value=0;
    setCurrentItem(0);
    connect(this,SIGNAL(activated(int)),this,SLOT(valueChanged(int )));
}


BitsPerSampleDropdown::~BitsPerSampleDropdown()
{
}

/*!
    \fn BitsPerSampleDropdown::getModifier()
 */
int BitsPerSampleDropdown::getModifier()
{
    switch(value){
        case 0: return 16;break;
        case 1: return 24;break;
        case 2: return 32;break;
    }
}


/*!
    \fn BitsPerSampleDropdown::valueChanged()
 */
void BitsPerSampleDropdown::valueChanged(int id)
{
    value=id;
    emit(valueChanged());
}






/*!
    \fn BitsPerSampleDropdown::setBps(int)
 */
void BitsPerSampleDropdown::setBps(int _value)
{
    switch(_value){
        case 16: setCurrentItem(0);value=0;break;
        case 24: setCurrentItem(1);value=1;break;
        case 32: setCurrentItem(2);value=2;break;
        default: setCurrentItem(0);value=0;
    }
}
