/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DRAWSOUNDWIDGETABSTRACT_H
#define DRAWSOUNDWIDGETABSTRACT_H

#include <qcanvas.h>
#include "wavecanvas.h"
#include "soundmanager.h"

/**
@author Predrag Viceic
*/
class DrawSoundWidgetAbstract : public QCanvasView
{
Q_OBJECT
public:
    DrawSoundWidgetAbstract(QWidget *parent,
                                                        const char *name, SoundManager*);
    ~DrawSoundWidgetAbstract();
    WaveCanvas* getCanvas();

protected:
    virtual void zoomChanged()=0;
    virtual void resized()=0;
public:

    long getZoomRatio();
    void setZoomRatio(long zr,long mid=-1);
    long getFirstVisibleSample();
    long getLastVisibleSample();
    long checkSamplePosition(long);
    bool updateCanvas;
protected:
    WaveCanvas* canvas;
    SoundManager* soundManager;
    QSize contentsSize;

    void resizeEvent(QResizeEvent*);

private:
    void setSoundManager(SoundManager* sm){
        soundManager=sm;
        canvas->setSoundManager(soundManager);
    }
    long zoomRatio;

public slots:
    void forceRepaint();
    void forceRepaint(long,long);
    long zoomToSamplePos(long,long);

};

#endif
