/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "scopeview.h"

ScopeView::ScopeView(QWidget *parent, const char *name)
 : QFrame(parent, name,WNoAutoErase)
{
    setFrameStyle(LineEditPanel | Sunken);
    frames=1024;
    position=0;
    lastRenderedPosition=0;
    horiz_steps=64;
    vert_steps=32;
    setPaletteBackgroundColor(QColor(0,0,0));
    pixmap=0;
    playing=FALSE;
    max_energies=new float[horiz_steps];
}


ScopeView::~ScopeView()
{
    zaparr(max_energies);
    if(pixmap) delete pixmap;
}

void ScopeView::showEvent(QShowEvent* ev){
    if(contentsRect().width()>0){
        pixmap=new QPixmap(contentsRect().width(),contentsRect().height());
    }
}

void ScopeView::paintEvent(QPaintEvent* ){

    int x=contentsRect().x();
    int y=contentsRect().y();
    if((!playing || ((position>=lastRenderedPosition+frames)&&
        position+frames<soundManager->getFrames())) && horiz_steps>0 &&
        contentsRect().width()>0){
        if(playing){
            float* lchannel=&soundManager->getLeftChannel()[position];
            float* rchannel=&soundManager->getRightChannel()[position];

            for (int i=0;i<horiz_steps;i++){
                max_energies[i]=lchannel[i];
            }

        }else{
            for (int i=0;i<horiz_steps;i++){
                max_energies[i]=0;
            }
        }
        lastRenderedPosition=position;

        //QFrame::paintEvent(ev);
        if(!pixmap){
            pixmap=new QPixmap(contentsRect().width(),contentsRect().height());
        }
        QPainter p(pixmap);
        p.fillRect(0,0,contentsRect().width(),contentsRect().height(),QBrush::black);
        float total_horiz_step_width=float(contentsRect().width())/float(horiz_steps);
        int rectWidth=round(round(total_horiz_step_width)*0.5f);
        int spaceH=round(round(total_horiz_step_width)*0.5f);
        float total_vert_step_width=float(contentsRect().height())/float(vert_steps);
        int rectHeight=round(round(total_vert_step_width)*0.5f);
        int spaceV=round(round(total_vert_step_width)*0.5f);

        QColor color(0,255,0);
        QColor fadedColor(0,255,0);
        QBrush brush(color);
        QBrush fadedBrush(fadedColor);
        for (int i=0;i<horiz_steps;i++){
            color.setRgb(0,255,0);
            for(int j=0;j<vert_steps;j++){
                int r=color.red();
                int g=color.green();
                int b=color.blue();
                if(r<255){
                    r=(int)(255*(double(j)/double(vert_steps)))*2;
                    r=r>255?255:r;
                }
                else if(g>0){
                    g=(int)(255*(double(vert_steps-j)/double(vert_steps)))*2;
                    g=g>255?255:g;
                }
                color.setRgb(r,g,b);
                fadedColor.setRgb(float(r)*0.5,float(g)*0.5,float(b)*0.5);
                brush.setColor(color);
                fadedBrush.setColor(fadedColor);
                if(max_energies[i]>=0 && j>=vert_steps/2){
                    if(max_energies[i]>=double(j-(vert_steps/2))/double(vert_steps/2)){

                        p.fillRect(x+i*(rectWidth+spaceH),
                                         y+(contentsRect().height()/2)-((j-vert_steps/2)*(rectHeight+spaceV)),
                                        rectWidth,-rectHeight,brush);

                    }else{
                        /*
                        p.fillRect(x+i*(rectWidth+spaceH),
                                         y+(contentsRect().height()/2)-((j-vert_steps/2)*(rectHeight+spaceV)),
                                        rectWidth,-rectHeight,fadedBrush);
                        */

                    }
                }else if(max_energies[i]<0 && j<vert_steps/2){

                    if(fabs(max_energies[i])>=double(j)/double(vert_steps/2)){
                        p.fillRect(x+i*(rectWidth+spaceH),
                                   y+(contentsRect().height()/2)+((j)*(rectHeight+spaceV)),
                                        rectWidth,rectHeight,brush);
                    }else{
                        /*
                        p.fillRect(x+i*(rectWidth+spaceH),
                                   y+(contentsRect().height()/2)+((j)*(rectHeight+spaceV)),
                                   rectWidth,rectHeight,fadedBrush);
                        */

                    }

                }
            }
        }
        p.end();
    }
    if (position<lastRenderedPosition) lastRenderedPosition=0;
    if(pixmap) bitBlt(this,x,y,pixmap,0,0,-1,-1);

    //QFrame::paintEvent(ev);
}

void ScopeView::customEvent(QCustomEvent* ev)
{
    if(ev->type() == 346798){
        position=(((PlayPositionChanged*)ev)->getPosition());
        playing=(((PlayPositionChanged*)ev)->getPlaying());
        update();
    }
}


/*!
    \fn ScopeView::setSoundManager(SoundManager*)
 */
void ScopeView::setSoundManager(SoundManager* sm)
{
    soundManager=sm;
}


/*!
    \fn ScopeView::resizeEvent(QResizeEvent* ev)
 */
void ScopeView::resizeEvent(QResizeEvent* ev)
{
    horiz_steps=round(ev->size().width()/3);
    horiz_steps=horiz_steps<1?1:horiz_steps;
    vert_steps=round(ev->size().height()/3);

    if(max_energies) zaparr(max_energies);
    max_energies=new float[horiz_steps];
    if(pixmap) zap(pixmap);
}

QSize ScopeView::sizeHint () const{
    return QSize(100,height());
}
