/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "verticalselectionrectangle.h"

VerticalSelectionRectangle::VerticalSelectionRectangle(QCanvas* canvas)
 : SelectionRectangle(canvas)
{
}

VerticalSelectionRectangle::VerticalSelectionRectangle(SoundManager* sm,int band_pos,int x, int y, int width, int height,
                                                                            QCanvas* canvas,bool _displayInfo)
 : SelectionRectangle(0,x,y,width,height,canvas,_displayInfo)
{
    start_band_pos=band_pos;
    inverted=FALSE;
    setY(y);
    soundManager=sm;
    soundManager->startBandChanged(start_band_pos);
}


VerticalSelectionRectangle::~VerticalSelectionRectangle()
{
    soundManager->startBandChanged(0);
    soundManager->endBandChanged(512);
    soundManager->setPlayingBandOnly(FALSE);
    hide();
}




/*!
    \fn VerticalSelectionRectangle::setStartBandPos(int)
 */
void VerticalSelectionRectangle::setStartBandPos(int pos)
{
    start_band_pos=pos;
    soundManager->startBandChanged(getStartBandPos());
    soundManager->endBandChanged(getEndBandPos());
}


/*!
    \fn VerticalSelectionRectangle::setEndBandPos(int)
 */
void VerticalSelectionRectangle::setEndBandPos(int pos)
{
    end_band_pos=pos;
    soundManager->startBandChanged(getStartBandPos());
    soundManager->endBandChanged(getEndBandPos());
    soundManager->setPlayingBandOnly(TRUE);
}


/*!
    \fn VerticalSelectionRectangle::getStartBandPos()
 */
int VerticalSelectionRectangle::getStartBandPos()
{
    return end_band_pos>start_band_pos?start_band_pos:end_band_pos;
}


/*!
    \fn VerticalSelectionRectangle::getEndBandPos()
 */
int VerticalSelectionRectangle::getEndBandPos()
{
    return end_band_pos>start_band_pos?end_band_pos:start_band_pos;
}
/*!
    \fn VerticalSelectionRectangle::drawShape( QPainter &p )
 */
void VerticalSelectionRectangle::drawShape( QPainter &p ){
	RasterOp oldROP=p.rasterOp();
        inverted?p.setRasterOp(AndNotROP):p.setRasterOp(AndNotROP);
         p.drawRect(rect());
         if(displayInfo){
            p.drawText(rect(),AlignCenter ,
                                QString("bands: %1-%2").
                                arg(getStartBandPos()).arg(getEndBandPos()));
        }
	p.setRasterOp(oldROP);
}


/*!
    \fn VerticalSelectionRectangle::setInverted(bool)
 */
void VerticalSelectionRectangle::setInverted(bool tf)
{
    inverted=tf;
    soundManager->inversionBandChanged(tf);
}


/*!
    \fn VerticalSelectionRectangle::getInverted()
 */
bool VerticalSelectionRectangle::getInverted()
{
    return inverted;
}
