/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bpmmodifierspinbox.h"

BPMModifierSpinBox::BPMModifierSpinBox(QWidget *parent, const char *name)
 : QSpinBox(parent, name)
{
        setMinValue(0);
        setMaxValue(7);
        setValue(5);
}


BPMModifierSpinBox::~BPMModifierSpinBox()
{
}




/*!
    \fn BPMModifierSpinBox::mapValueToText(int value)
 */
QString BPMModifierSpinBox::mapValueToText(int value)
{
    switch(value){
        case 0: return QString("1/4");break;
        case 1: return QString("1/3");break;
        case 2: return QString("1/2");break;
        case 3: return QString("2/3");break;
        case 4: return QString("3/4");break;
        case 5: return QString("1");break;
        case 6: return QString("4/3");break;
        case 7: return QString("2");break;

    }
}


/*!
    \fn BPMModifierSpinBox::mapTextToValue(bool* ok)
 */
int BPMModifierSpinBox::mapTextToValue(bool* ok)
{
    if ( text() == "1/4" )    return 0;
    if ( text() == "1/3" )    return 1;
    if ( text() == "1/2" )    return 2;
    if ( text() == "2/3" )    return 3;
    if ( text() == "3/4" )    return 4;
    if ( text() == "1" )    return 5;
    if ( text() == "4/3" )    return 6;
    if ( text() == "2" )    return 7;

}


/*!
    \fn BPMModifierSpinBox::getModifier()
 */
float BPMModifierSpinBox::getModifier()
{
    switch(value()){
        case 0: return 1.0/4.0;break;
        case 1: return 1.0/3.0;break;
        case 2: return 1.0/2.0;break;
        case 3: return 2.0/3.0;break;
        case 4: return 3.0/4.0;break;
        case 5: return 1;break;
        case 6: return 4.0/3.0;break;
        case 7: return 2;break;
    }
}
