/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EFFECTFRAME_H
#define EFFECTFRAME_H

#include <iostream.h>
#include <qframe.h>
#include <ladspaeffect.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <effectportframe.h>
#include <qptrlist.h>
#include <qwidgetstack.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qhbuttongroup.h>
/**
@author Predrag Viceic
*/
class EffectFrame : public QVBox
{
Q_OBJECT
public:
    EffectFrame(LADSPAEffect*,QWidget* parent=0,const char* name=0);

    ~EffectFrame();
    void setApplyPolicy(int);
    void reinit();
    QSize sizeHint () const;

private:
    LADSPAEffect* effect;
    QMenuBar* portsBar;
    QPtrList<EffectPortFrame> portFrames;
    QWidgetStack* stack;
    int onReleasePolMenuIDX;
    int onChangePolMenuIDX;
    int applyMenuIDX;
    int undoApplyMenuIDX;
    QPopupMenu * executeMenu;
    QPushButton* pointsButton;
    QPushButton* linesButton;
    QPushButton* polylinesButton;
    QPushButton* splinesButton;
    QHButtonGroup* drawModeBG;


public slots:
    void apply();
    void apply(long,long);
    void show();
    void setZoomRatio(long);
    void visibleAreaChanged(long,long);
    void setContentsPos(int,int);
    void switchOnReleaseApplyPolicy();
    void switchOnChangeApplyPolicy();
    void changeDrawMode(EffectPortFrame::DrawMode dm);


signals:
    void applyMe(LADSPAEffect*);
    void applyMe(LADSPAEffect*,long,long);


protected:
    void closeEvent( QCloseEvent*);
};

#endif
