/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "envelopecontrollerwidget.h"
#include "envelopedata.h"
#include <qstringlist.h>

EnvelopeControllerWidget::EnvelopeControllerWidget(QWidget *parent, const char *name)
 : QHBox(parent, name)
{

    setSpacing(0);
    setMargin(0);

    inHolder=false;
    start_frame=0;
    end_frame=0;
    envData=new EnvelopeData();
    QFont font=this->font();
    font.setPixelSize(11);
    
    QVBox* onoffbox=new QVBox(this);
    onoffbox->setFixedWidth(20);
    onoffbox->setFixedHeight(48);
    onoffbox->setSpacing(0);
    onoffbox->setMargin(0);

    onoff=new QPushButton(onoffbox);
    onoff->setText("off");
    onoff->setFont(font);
    onoff->setToggleButton(TRUE);
    onoff->setOn(FALSE);
    onoff->setFixedHeight(16);
    onoff->setFixedWidth(20);

    QWidget* empty1=new QWidget(onoffbox);
    empty1->setFixedHeight(32);

    connect(onoff,SIGNAL(toggled(bool)),this,SLOT(onoffChanged(bool )));

    font.setPixelSize(8);
    displayEnvelope=new DisplayEnvelopeWidget(this);
    displayEnvelope->setEnvData(envData);
    displayEnvelope->setFixedHeight(48);
    displayEnvelope->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    displayEnvelope->setLineWidth(2);

    connect(displayEnvelope,SIGNAL(envelopeChanged(EnvelopeData* )),
            this, SIGNAL(envelopeChanged(EnvelopeData* )));

    QVBox* durationBox=new QVBox(this);
    durationBox->setFixedWidth(30);

    QLabel* durNameLabel=new QLabel(durationBox);
    durNameLabel->setText("dur:");
    durNameLabel->setFont(font);
    durNameLabel->setAlignment(AlignHCenter);

    envDurationWidget=new PotentiometerWidget(durationBox);
    envDurationWidget->setFixedHeight(30);
    envDurationWidget->setFixedWidth(30);
    envDurationWidget->setMinValue(100);
    envDurationWidget->setMaxValue(3000);
    envDurationWidget->setValue(100);

    envData->env_duration=100;


    QLabel* durLabel=new QLabel(durationBox);
    durLabel->setNum(100);


    durLabel->setFont(font);
    durLabel->setAlignment(AlignHCenter);

    connect(envDurationWidget,SIGNAL(valueChanged(int)), durLabel,SLOT(setNum(int)));
    connect(envDurationWidget,SIGNAL(dialReleased()),this,SLOT(durationChanged()));

    QVBox* resolutionBox=new QVBox(this);
    resolutionBox->setFixedWidth(30);

    QLabel* resNameLabel=new QLabel(resolutionBox);
    resNameLabel->setText("res:");
    resNameLabel->setFont(font);
    resNameLabel->setAlignment(AlignHCenter);

    envResolutionWidget=new PotentiometerWidget(resolutionBox);
    envResolutionWidget->setFixedHeight(30);
    envResolutionWidget->setFixedWidth(30);
    envResolutionWidget->setMinValue(10);
    envResolutionWidget->setMaxValue(1024);
    envResolutionWidget->setValue(100);
    envResolutionWidget->setEnabled(FALSE);

    envData->env_resolution=100;


    QLabel* resLabel=new QLabel(resolutionBox);
    resLabel->setNum(100);
    resLabel->setFont(font);
    resLabel->setAlignment(AlignHCenter);

    connect(envResolutionWidget,SIGNAL(valueChanged(int)), resLabel,SLOT(setNum(int)));
    connect(envResolutionWidget,SIGNAL(dialReleased()),this,SLOT(resolutionChanged()));


    QButtonGroup* optionsBG=new QButtonGroup(this);
    optionsBG->setExclusive(TRUE);
    optionsBG->setInsideMargin(0);
    optionsBG->setInsideSpacing(0);
    optionsBG->setFrameShape(NoFrame);
    optionsBG->setFixedWidth(0);
    optionsBG->setFixedHeight(0);

    QVBox* optionsbox1=new QVBox(this);
    QVBox* optionsbox2=new QVBox(this);

    optionsbox1->setFixedWidth(30);
    optionsbox2->setFixedWidth(30);
    optionsbox1->setFixedHeight(48);
    optionsbox2->setFixedHeight(48);

    optionsbox1->setFrameShape(NoFrame);
    optionsbox1->setSpacing(0);
    optionsbox1->setMargin(0);
    optionsbox2->setFrameShape(NoFrame);
    optionsbox2->setEnabled(FALSE);
    optionsbox2->setSpacing(0);
    optionsbox2->setMargin(0);



    font.setPixelSize(11);

    QPushButton* end=new QPushButton(optionsbox1);
    end->setText("end");
    end->setFont(font);
    end->setToggleButton(TRUE);
    end->setFixedHeight(16);
    end->setFixedWidth(30);
    optionsBG->insert(end);
    QPushButton* cont=new QPushButton(optionsbox1);
    cont->setText("cont");
    cont->setFont(font);
    cont->setToggleButton(TRUE);
    cont->setFixedHeight(16);
    cont->setFixedWidth(30);
    optionsBG->insert(cont);
    QPushButton* next=new QPushButton(optionsbox1);
    next->setText("next");
    next->setFont(font);
    next->setToggleButton(TRUE);
    next->setFixedHeight(16);
    next->setFixedWidth(30);
    optionsBG->insert(next);

    QPushButton* stretch=new QPushButton(optionsbox2);
    stretch->setText("str");
    stretch->setFont(font);
    stretch->setToggleButton(TRUE);
    stretch->setFixedHeight(16);
    stretch->setFixedWidth(30);
    optionsBG->insert(stretch);
    QPushButton* stretch2=new QPushButton(optionsbox2);
    stretch2->setText("str2");
    stretch2->setFont(font);
    stretch2->setToggleButton(TRUE);
    stretch2->setFixedHeight(16);
    stretch2->setFixedWidth(30);
    optionsBG->insert(stretch2);
    QPushButton* auto1=new QPushButton(optionsbox2);
    auto1->setText("auto");
    auto1->setFont(font);
    auto1->setToggleButton(TRUE);
    auto1->setFixedHeight(16);
    auto1->setFixedWidth(30);
    optionsBG->insert(auto1);
    cont->setOn(TRUE);


    connect(optionsBG,SIGNAL(clicked(int)),this,SLOT(endModeChanged(int)));
}


EnvelopeControllerWidget::~EnvelopeControllerWidget()
{
}





/*!
    \fn EnvelopeControllerWidget::setData(QString envData)
 */
void EnvelopeControllerWidget::setData(QString envDataS)
{
    if(envData){
        envData->setData(envDataS);
        update();
    }
}


/*!
    \fn EnvelopeControllerWidget::setInHolder(bool)
 */
void EnvelopeControllerWidget::setInHolder(bool tf)
{
    inHolder=tf;
}


/*!
    \fn EnvelopeControllerWidget::getEndFrame()
 */
long EnvelopeControllerWidget::getEndFrame()
{
    return end_frame;
}


/*!
    \fn EnvelopeControllerWidget::getStartFrame()
 */
long EnvelopeControllerWidget::getStartFrame()
{
    return start_frame;
}


/*!
    \fn EnvelopeControllerWidget::setEndFrame(long ef)
 */
void EnvelopeControllerWidget::setEndFrame(long ef)
{
    end_frame=ef;
}


/*!
    \fn EnvelopeControllerWidget::setStartFrame(long sf)
 */
void EnvelopeControllerWidget::setStartFrame(long sf)
{
    start_frame=sf;
}


/*!
    \fn EnvelopeControllerWidget::getEnvData()
 */
EnvelopeData* EnvelopeControllerWidget::getEnvData()
{
    return envData;
}


/*!
    \fn EnvelopeControllerWidget::durationChanged()
 */
void EnvelopeControllerWidget::durationChanged()
{
    envData->env_duration=envDurationWidget->value();
    emit(envelopeChanged(envData));
}


/*!
    \fn EnvelopeControllerWidget::resolutionChanged()
 */
void EnvelopeControllerWidget::resolutionChanged()
{
    envData->env_resolution=envResolutionWidget->value();
    emit(envelopeChanged(envData));
}


/*!
    \fn EnvelopeControllerWidget::endModeChanged(int btn)
 */
void EnvelopeControllerWidget::endModeChanged(int btn)
{
    cout<<"end modeChanged: "<<btn<<endl;
    switch(btn){
        case 0:{envData->env_mode=EnvelopeData::FIT_TO_DURATION;break;}
        case 1:{envData->env_mode=EnvelopeData::FIT_TO_DURATION_CONTINUE;break;}
        case 2:{envData->env_mode=EnvelopeData::FIT_TO_SAMPLES;break;}
    }
    emit(envelopeChanged(envData));
}


/*!
    \fn EnvelopeControllerWidget::onoffChanged(bool on)
 */
void EnvelopeControllerWidget::onoffChanged(bool on)
{
    if(on){
        onoff->setText("on");
        envData->setEnabled(1);
    }
    else{
        onoff->setText("off");
        envData->setEnabled(0);
    }
    emit(envelopeChanged(envData));
}
