/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ENVELOPEDATA_H
#define ENVELOPEDATA_H

#include <qdragobject.h>
#include "mymath.h"
#include "defs.h"


/**
@author Predrag Viceic
*/
class EnvelopeData : public QTextDrag
{
Q_OBJECT
public:
    enum mode{FIT_TO_DURATION,FIT_TO_DURATION_CONTINUE,
                            FIT_TO_SAMPLES, STRETCH_TO_SAMPLES, STRETCH_IF_LONGER,AUTO};
    EnvelopeData(const QString & text,QWidget * dragSource = 0, const char * name = 0);
    EnvelopeData(QWidget * dragSource = 0, const char * name = 0 );
    ~EnvelopeData();
    QString toString();
    float getEnvAt(float x,float dt);
    mode getMode();
    float getDuration();
    void setData(QString envDataS);
    void setReleaseCy(float ry);
    void setAttack(float a);
    void setAttackCx(float ax);
    void setAttackCy(float ay);
    void setDecay(float a);
    void setDecayCx(float dx);
    void setDecayCy(float dy);
    void setHold(float a);
    void setRelease(float a);
    void setReleaseCx(float rx);
    void setSustain(float a);
    int isEnabled();
    void setEnabled(int e);


    float attack;
    float release;
    float decay;
    float hold;
    float sustain;
    float env_duration;
    float env_resolution;
    mode env_mode;
    MyMath::FPoint2D attackC;
    MyMath::FPoint2D decayC;
    MyMath::FPoint2D releaseC;

protected:
    int enabled;
};

#endif
