//
// C++ Interface: blinkable
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BLINKABLE_H
#define BLINKABLE_H

#include <qobject.h>
#include <qcanvas.h>
#include <qtimer.h>
#include "defs.h"

/**
@author Predrag Viceic
*/
class Blinkable : public QObject
{
Q_OBJECT
public:
    Blinkable(QObject *parent = 0, const char *name = 0);

    ~Blinkable();

    int nbSteps;
    int stepInterval;
    int totalDuration;
    int currentStep;
    int currentDuration;
    QTimer* timer;
    void init(){
        currentStep=0;
        currentDuration=0;
    }
    int nextStep(){
        if(currentStep==nbSteps-1) currentStep=0;
        else currentStep++;
        currentDuration+=stepInterval;
        if(currentDuration<totalDuration) return currentStep;
        else return -1;
    }
    virtual void executeBlink(int step) = 0;
    void startBlink(Blinkable* blinkable, int nbSteps, int stepInterval, int totalDuration);

public slots:
    void blink();
};

#endif
