/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DISPLAYENVELOPEWIDGET_H
#define DISPLAYENVELOPEWIDGET_H

#include <qlabel.h>
#include <defs.h>
#include "envelopedata.h"

/**
@author Predrag Viceic
*/
class DisplayEnvelopeWidget : public QLabel
{
Q_OBJECT
public:
    DisplayEnvelopeWidget(QWidget *parent = 0, const char *name = 0);

    ~DisplayEnvelopeWidget();
    void drawBezierSegment(QPainter* p,QPoint start, QPoint end, QPoint control);
    void drawThickPoint(QPainter* p,QPoint point);
public slots:
    void setEnvData(EnvelopeData* ed);
protected:
    EnvelopeData* envData;
    QRect attackRect;
    QRect holdRect;
    QRect decayRect;
    QRect sustainRect;
    QRect releaseRect;
    QRect attackPRect;
    QRect holdPRect;
    QRect decayPRect;
    QRect sustainPRect;
    QRect releasePRect;
    QRect attackCRect;
    QRect holdCRect;
    QRect decayCRect;
    QRect sustainCRect;
    QRect releaseCRect;
    void resizeEvent ( QResizeEvent * );
    void drawContents ( QPainter * );
    void mousePressEvent( QMouseEvent * );
    void mouseMoveEvent( QMouseEvent * );
    void mouseReleaseEvent( QMouseEvent * );
private:
    void computeRects();
    QColor attackColor;
    QColor holdColor;
    QColor decayColor;
    QColor sustainColor;
    QColor releaseColor;
    enum movingPart{NONE,ATTACK,ATTACKC,HOLD,DECAY,DECAYC,SUSTAIN,RELEASE,RELEASEC};
    movingPart moving;
signals:
    void envelopeChanged(EnvelopeData* envData);

};

#endif
