/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qapplication.h>
#include "freecycle.h"
#include "ueberstyle.h"
#include "pics/icons.h"
#include "defs.h"

int main( int argc, char ** argv ) {
    QApplication a( argc, argv );

    for (int i=0;i<argc;i++){
        if(QString(argv[i]).contains("--ueber",FALSE)){
            QApplication::setStyle( new UeberStyle() );
        }
    }

    QString filename="";
    if(argc>1 && !QString(argv[argc-1]).contains("--")){
        filename=QString(argv[argc-1]);
    }


    //QSplashScreen *splash = new QSplashScreen(QPixmap(qembed_findImage("freecycle-splash")));
    //splash->show();
    Freecycle * mw = new Freecycle();
    mw->setCaption( release );
    mw->setMainApplication(&a);
    mw->show();
    //sleep(2);
    //splash->finish( mw );
    //delete splash;
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    if(!filename.isEmpty()){
         if (filename.endsWith(".wav",FALSE) ||
             filename.endsWith(".aiff",FALSE) ||
             filename.endsWith(".wav",FALSE) ||
             filename.endsWith(".aif",FALSE) ||
             filename.endsWith(".au",FALSE) ||
             filename.endsWith(".snd",FALSE) ||
             filename.endsWith(".raw",FALSE) ||
             filename.endsWith(".iff",FALSE) ||
             filename.endsWith(".swx",FALSE) ||
             filename.endsWith(".voc",FALSE) ||
             filename.endsWith(".w64",FALSE) ||
             filename.endsWith(".pvf",FALSE)) mw->load(filename);
         else if(filename.endsWith(".frc.tgz",FALSE)) mw->loadProject(filename);
    }
    return a.exec();
}
