/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREVIEWWAVEDISPLAY_H
#define PREVIEWWAVEDISPLAY_H

#include <qframe.h>
#include <sndfile.h>
#include <qpainter.h>
#include <qcolor.h>
#include "defs.h"
#include "playpositionchanged.h"
#include "qpixmap.h"
#include "pics/icons.h"
#include <math.h>  //apparently Mandrake 10 needs this

/**
@author Predrag Viceic
*/
class PreviewWaveDisplay : public QFrame
{
Q_OBJECT
public:
    PreviewWaveDisplay(QWidget *parent = 0, const char *name = 0);

    ~PreviewWaveDisplay();
    void drawContents ( QPainter * );
    void setSoundFile(QString*);
    int getDisplayedLength();
    void loadWave();
    int getWaveLength();
    int getJump();
    void customEvent(QCustomEvent*);
    void paintEvent ( QPaintEvent * event );
    QSize minimumSizeHint() const;

protected:
    QString* soundfile;
    long maxLengthDisplayedC;
    long displayedLength;
    long waveLength;
    float* buff;
    int startDisplayPosition;
    int jump;
    long playingPosition;
    QPixmap* pixmap;
    bool redraw;
    int oldPositionLineX;
    bool moving;
    bool fileScrewed;
    void resizeEvent ( QResizeEvent * ) ;
    void mousePressEvent ( QMouseEvent * e );
    void mouseMoveEvent ( QMouseEvent * e );
    void mouseReleaseEvent ( QMouseEvent * e );



public slots:
    void setDisplayedLength(int mdl);
    void setStartDisplayPosition(int sdp);

private:
    QColor leftBgColor;
    QColor rightBgColor;
    QColor fgColor;
signals:
    void maxStartPositionChangedSig(int);
    void startPositionChangedSig(int);
    void playPositionChangedSig(long);
    void stopSig();
    void pauseSig();
    void playSig();
};

#endif
