/*
  (C) 2006 Z RESEARCH Inc.
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301 USA
*/

#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <getopt.h>

#include "compat.h"

/*
 * Produce output for --help
 */

extern const char *argp_program_bug_address;

static void
argp_help_ (const struct argp *__argp, char **__argv)
{
  const struct argp_option *options = __argp->options;
  
  fprintf (stderr, "Usage: %s %s\n", basename (__argv[0]), __argp->args_doc);
  fprintf (stderr, "%s.\n", __argp->doc);
  
  while (options->name) {
    fprintf (stderr, "  -%c, --%s%s%s\n\t\t%s\n", options->key,
             options->name, options->arg ? "=" : "", options->arg ? options->arg : "",
             options->doc);
    options++;
  }
  
  fprintf (stderr, "\nMandatory or optional arguments to long options are also mandatory nor optional for any corresponding short options.\n");
  fprintf (stderr, "\nReport bugs to %s.\n", argp_program_bug_address);
  exit (0);
}

error_t
argp_parse_ (const struct argp * __argp,
             int __argc, char **  __argv,
             unsigned __flags, int * __arg_index,
             void * __input)
{
  const struct argp_option * options = __argp->options;
  struct argp_state state;
  
  state.input = __input;
  
  int num_opts = 0;
  struct option * getopt_long_options;
  char *getopt_short_options;
  int c;
  int short_idx = 0;
  int long_idx = 0;
  
  while (options->name) {
    num_opts++;
    options++;
  }
  
  getopt_long_options = (struct option *) calloc (num_opts+1, sizeof (*getopt_long_options));
  getopt_short_options = (char *) calloc (num_opts+1, 2 * sizeof (char));
  
  options = __argp->options;
  
  while (options->name) {
    getopt_short_options[short_idx++] = options->key;
    getopt_long_options[long_idx].name = options->name;
    getopt_long_options[long_idx].val = options->key;
    
    if (options->arg != NULL) {
      getopt_short_options[short_idx++] = ':';
      getopt_long_options[long_idx].has_arg = 1;
    }
    options++;
    long_idx++;
  }
  
  int option_index = 0;
  
  while (1) {
    
    c = getopt_long (__argc, __argv, getopt_short_options,
                     getopt_long_options, &option_index);
    
    if (c == -1)
      break;
    
    if (c == '?')
      argp_help_ (__argp, __argv);
    
    __argp->parser (c, optarg, &state);
  }
  
  while (option_index < __argc) {
    __argp->parser (ARGP_KEY_ARG, __argv[option_index], &state);
    option_index++;
  }
  
  return 0;
}

void
argp_help (const struct argp *argp, FILE *stream, unsigned flags, char *name)
{
  fprintf (stream, "This is a help message");
}

#ifndef HAVE_GETLINE
/* Replacement for glibc getline */
ssize_t
freehoo_getline (char **buf, size_t *size, FILE *fp)
{
  ssize_t n = 0;
  
  if (buf == NULL || size == NULL) {
    errno = EINVAL;
    return -1;
  }
  
  if (*buf == NULL || *size == 0) {
    *size = 120;
    *buf = (char *)malloc(*size);
    if (*buf == NULL)
      return -1;
  }
  
  for (;;) {
    int ch;
    
    if (n + 2 > *size) {
      size_t newsize = *size * 2;
      char *newbuf = (char *)realloc(*buf, newsize);
      
      if (newbuf == NULL)
	return -1;
      *buf = newbuf;
      *size = newsize;
    }
    
    ch = fgetc(fp);
    if (ch == -1) {
      (*buf)[n++] = '\0';
      return -1;
    }
    
    (*buf)[n++] = ch;
    
    if (ch == '\n') {
      (*buf)[n++] = '\0';
      return n;
    }
  }
}
#endif
