;;; conference.scm: creates a virtual yahoo conference
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;;
;;; conference.scm should be automatically loaded by init.scm
;;; usage:
;;; To start a conference with rms, thomas and roland
;;;  ?eval (cf-start '(rms thomas roland))
;;; To end the conference
;;;  ?eval (cf-end)

(if (defined? 'conference-group)
    '()
    (begin
      (define conference-group '())))

(define (conference-who group)
  "list all conference members"
  (display (string-append "Conference members ["
			  (list->csv group)
			  "]"))
  (newline))
  
(define (conference-startup-message group)
  "announce start of conference"
  (send-message-to-group group
			 (string-append
			  "You are in Conference with ["
			  (fh-get-default-login-id)
			  ", "
			  (list->csv conference-group)
			  "]"))
  (send-message-to-group group
			 (string-append
			  "To reach the Conference, send messages to ["
			  (fh-get-default-login-id)
			  "]"))
  (conference-who group)
  (display (string-append "Conference name [cf]"))
  (newline))
  
(define (conference-end-message group)
  "announce close of conference"
  (send-message-to-group group "Conference closed")
  (display "Conference closed")(newline))

(define (conference-send-message conference-name message)
  "send conference message"
  (and (string=? conference-name "cf")
	   (send-message-to-group conference-group
				  (string-append
				   "[" (fh-get-default-login-id)
				   "] "
				   message))
	   (fh-hook-return)))

(define (conference-receive-message from message)
  "receive conference message"
  (for-each (lambda (buddy)
		  (and (string=? buddy from)
		       (send-message-to-group conference-group
					      (string-append
					       "["
					       from
					       "] "
					       message))))
		conference-group))

(define (cf-start buddy-list)
  "start a conference with list of buddys"
  (set! conference-group buddy-list)
  (conference-startup-message conference-group)
  (add-hook! fh-message-send-hook conference-send-message)
  (add-hook! fh-message-receive-hook conference-receive-message)
  (fh-set-current-target-buddy! "cf"))

(define (cf-end)
  "end conference"
  (conference-end-message conference-group)
  (set! conference-group '())
  (fh-set-current-target-buddy! #f))


;;; Dynamic command support
(fh-register-command!
 '("?vconf-start"
   "?vconf-start CONF-BUDDY-LIST\n\t- create a virtual conference with given CONF-BUDDY-LIST"))

(define (?vconf-start args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 0)
      (begin
	(cf-start args-list)
	(fh-register-command! '("?vconf-end" "?vconf-end\n\t- close the virtual conference"))
	(fh-register-command! '("?vconf-who" "?vconf-who\n\t- virtual conference members"))
	(fh-unregister-command! "?vconf-start"))
      (begin
	(display "?vconf-start: wrong number of arguments")
	(newline)
	(display "usage: ?vconf-start userlist")
	(newline))))

(define (?vconf-end args-list)
  (cf-end)
  (fh-unregister-command! "?vconf-end")
  (fh-unregister-command! "?vconf-who")
  (fh-register-command!
   '("?vconf-start"
     "?vconf-start CONF-BUDDY-LIST\n\t- create a virtual conference with given CONF-BUDDY-LIST")))


(define (?vconf-who args-list)
  (conference-who conference-group))
