;;; history.scm: logs all the sent and received messages in
;;; ~/.freehoo/history directory

;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; history path
(define history-path "HISTORY PATH WILL BE SET IN POST-STARTUP")

;;; append this message to history file with time stamp
(define (history-raw filename message)
  "log the message to history afile"
  (define history-file (open-file filename "a"))
  (display message history-file)
  (close-output-port history-file))

;;; append this message to history file with time stamp
(define (history filename buddy message)
  "log the message to history file"
  (history-raw filename
	       (string-append 
		(local-date-time) " [" buddy "] " message "\n")))

(define (history-create-dirs)
  "create history folders"
  ;;; if we are running for the first time, then create
  ;;; ~/.freehoo/history
  (catch 'system-error
	 (lambda ()
	   (mkdir (string-append (fh-get-config-dir)
				 "/history")))
	 (lambda args #f))
  ;;; if we are logging in for first time, then create
  ;;; ~/.freehoo/history/<yahoo-id>
  (catch 'system-error
	 (lambda ()
	   (mkdir history-path))
	 (lambda args #f)))

;;; hook procedure for logging all sent messages
(define (log-sent-message to message)
  "hook procedure for logging all sent messages"
  (history (string-append history-path "/" to)
	   (fh-get-default-login-id)
	   message))

;;; hook procedure for logging all revceived messages
(define (log-received-message from message)
  "hook procedure for logging all revceived messages" 
  (history (string-append history-path "/" from)
	   from
	   message))
  
;;; hook procedure for logging all revceived offline messages
(define (log-received-offline-message from message time)
  "hook procedure for logging all revceived messages" 
  (define history-filename
    (string-append history-path "/" from))
  (define history-message
    (string-append time " [" from "] [OFFLINE] " message "\n"))
  (history-raw history-filename history-message))
  
(define (post-startup)
  "post startup hook"
  (set! history-path (string-append
		      (fh-get-config-dir)
		      "/history/"
		      (fh-get-default-login-id)))
  (history-create-dirs))

;;; hook the logging procedures to send and reveice hooks
(add-hook! fh-message-send-hook log-sent-message)
(add-hook! fh-message-receive-hook log-received-message)
(add-hook! fh-message-receive-offline-hook log-received-offline-message)
(add-hook! fh-login-post-hook post-startup)
