;;; alias.scm: alias facility to freehoo
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; define an alias alist like below in your ~/.freehoo/freehoo.scm
;;; (define alias '((gnu . (gnuindian abindian nagappanal kvisu2000))
;;; 		    (mridul . (gnuindian))
;;; 		    (bala . (balugi))
;;; 		    (nags . (nagappanal))
;;; 		    (visu . (kvisu2000))))

(if (defined? 'alias)
    '()
    (begin
      (define alias '())))
 
(define (alias-buddy-name to msg)
  "expand alias for buddy name"
  (and (list? (assq-ref alias  (string->symbol to)))
       (send-message-to-group (assq-ref alias (string->symbol to)) msg)
           ;;; call return from the current hook operation to 
           ;;; cancel the current operation
       (fh-hook-return)))

(add-hook! fh-message-send-hook alias-buddy-name)

;;; Dynamic command support
(fh-register-command!
 '("?alias"
   "?alias BUDDY BUDDY-LIST\n\t- alias a virtual BUDDY to BUDDY-LIST"))

(define (?alias args-list)
  (if (> (length args-list) 1)
      (set! alias (assoc-set! alias (car args-list) (cdr args-list)))
      (begin
	(display "?alias: wrong number of arguments\n")
	(display "usage: ?alias BUDDY BUDDY-LIST\n"))))
