/*
   yahoo-adapter.c: higher level wrapper to libyahoo2 functions

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* READ ME FIRST:
   All the process_*  and handle_yahoo_message functions should use
   PRINTF_MESSAGE only to print any message to screen. This will
   ensure proper insertion of message into readline buffer.
*/


#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <guile/gh.h>
#include <readline/readline.h>

#include <glib.h>

#include "freehoo.h"
#include "interpreter.h"
#include "yahoo-adapter.h"
#include "yahoo-backend.h"
#include "fh-utils.h"
#include "extension.h"
#include <config.h>

GHashTable *fh_buddy_list = NULL;
static char current_target_buddy[USERNAME_LENGTH];
int auto_insert_mode = 0;

int 
get_auto_insert_mode (void)
{
  return auto_insert_mode;
}

void 
set_auto_insert_mode (int auto_insert_mode_value)
{
  auto_insert_mode = auto_insert_mode_value;
}

void 
set_current_target_buddy (char *current_target_buddy_value)
{
  if (current_target_buddy_value)
    strcpy (current_target_buddy, current_target_buddy_value);
  else
    current_target_buddy[0] = 0;
}

char *
get_current_target_buddy (void)
{
  return current_target_buddy;
}

void 
send_message (char *to, char *message)
{
  /* hook evaluation */
  set_current_target_buddy (to);	// AUTO-INSERT-MODE
  
  set_hook_return (0);
  scm_run_hook (get_message_send_hook (),
		gh_list (gh_str02scm (to),
			 gh_str02scm (message),
			 SCM_UNDEFINED));
  
  if (get_hook_return () == 1)
    return;

  yahoo_send_im (get_fh_session ()->id, NULL, to, message, 0);
}

/* this function is primarily for scm-procedure. using this function
for other purposes is not justified 
*/
void 
send_message_no_hook (char *to, char *message)
{
  // dont set current_target_buddy from inside this call. otherwise
  // it will confuse "session (AUTU-INSERT-MODE). 
  // set_current_target_buddy (to); // AUTO-INSERT-MODE

  yahoo_send_im (get_fh_session ()->id, NULL, to, message, 0);
}

void 
fh_key_destroy (gpointer key)
{
  return;
}

void 
fh_value_destroy (gpointer data)
{
  return;
}

void
build_fh_buddy_table (const void *data)
{
  yahoo_account *hoob = (yahoo_account *) data;
  hoob->msg = NULL;
  g_hash_table_insert (fh_buddy_list, hoob->yahoo_id, hoob);
}

void 
build_fh_buddy_list ()
{
  YList *buds;
  buds = get_fh_buddies ();
  fh_buddy_list = g_hash_table_new (g_str_hash, g_str_equal);
  for(; buds; buds = buds->next) 
    build_fh_buddy_table (buds->data);
}

void
show_buddy (gpointer data)
{
  static char *current_group = NULL;
  yahoo_account *buddy = (yahoo_account *) data;
  yahoo_account *hoob = NULL;

  if (!current_group || strcmp (current_group, buddy->group))
    {
      current_group = buddy->group;
      printf ("[%s]\n", current_group);
    }
  
  hoob = g_hash_table_lookup (fh_buddy_list, buddy->yahoo_id);
  if (!hoob)
    {
      /* Sometimes libyahoo2 buddy_list and fh_buddy_list doesn't
	 synchronize in realtime. */
      // printf ("Error: No %s found in fh_buddy_list\n", buddy->id);
      return;
    }
  
  if (get_who_state () &&
      hoob->status != YAHOO_STATUS_AVAILABLE &&
      hoob->status == YAHOO_STATUS_OFFLINE)
    {
      return;
    }

  printf (" %c %s",
	  ((hoob->status == YAHOO_STATUS_AVAILABLE) ? '*' : ' '),
	  hoob->yahoo_id);
  
  if (hoob->status == YAHOO_STATUS_CUSTOM)
    {
      printf (" (%s)", hoob->msg);
    }
  else
    {
      if (hoob->status != YAHOO_STATUS_OFFLINE &&
	  hoob->status != YAHOO_STATUS_AVAILABLE)
	{
	  printf (" (%s)", yahoo_status_code (hoob->status));
	}
    }
  printf ("\n");
}

void
show_ignore (gpointer data)
{
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  printf ("%s\n", buddy->id);
}

void 
display_buddy_list ()
{
  YList *buds = get_fh_buddies ();
  for(; buds; buds = buds->next) 
    show_buddy (buds->data);
}

void 
display_ignore_list ()
{
  YList *igns = get_fh_ignores ();
  for(; igns; igns = igns->next) 
    show_ignore (igns->data);
}

GHashTable *
get_fh_buddy_list ()
{
  return fh_buddy_list;
}
