/* 
   yahoo-adapter.h: higher level wrapper to libyahoo2 functions

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#ifndef _YAHOO_ADAPTER_H
#define _YAHOO_ADAPTER_H

#include <glib.h>
#include <yahoo2.h>

// yahoo status
#define YAHOO_STATUS_UNKNOWN -1

int get_auto_insert_mode (void);
void set_auto_insert_mode (int auto_insert_mode_value);

char *get_received_message_from (void);

void set_current_target_buddy (char *current_target_buddy_value);
char *get_current_target_buddy (void);

void send_message (char *to, char *message);
void send_message_no_hook (char *to, char *message);

void fh_key_destroy (gpointer key);
void fh_value_destroy (gpointer data);
void build_fh_buddy_table (const void *data);
void build_fh_buddy_list ();

void show_buddy (gpointer data);
void show_ignore (gpointer data);
void display_buddy_list ();
void display_ignore_list ();
GHashTable *get_fh_buddy_list ();

#endif
