/* 
   scm-procedures.h: scm procedures that are exported to
   guile environment
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#ifndef _SCM_PROCEDURES_H
#define _SCM_PROCEDURES_H

SCM ex_version (void);
SCM ex_display (SCM scm_message);
SCM ex_bell (void);
SCM ex_toggle_x (SCM scm_what2toggle);
SCM ex_hook_return (void);
SCM ex_set_default_status_x (SCM scm_status);
SCM ex_get_home_dir (void);
SCM ex_get_config_dir (void);
SCM ex_get_config_filename (void);
SCM ex_get_download_filename (void);
SCM ex_set_default_login_id_x (SCM scm_default_login_id);
SCM ex_get_default_login_id (void);
SCM ex_set_default_password_x (SCM scm_default_password);
SCM ex_set_current_target_buddy_x (SCM scm_current_target_buddy, SCM mode);
SCM ex_send_message (SCM scm_to, SCM scm_message);
SCM ex_send_message_no_hook (SCM scm_to, SCM scm_message);
SCM ex_register_command_x (SCM command);
SCM ex_unregister_command_x (SCM command);
SCM ex_set_prompt_x (SCM scm_prompt);
SCM ex_get_buddy_list ();
SCM ex_add_buddy (SCM scm_buddy, SCM scm_group);
SCM ex_fh_quit ();
SCM ex_fh_logoff ();

SCM ex_get_global_extensions_directory (void);
SCM ex_get_local_extensions_directory (void);
SCM ex_load (SCM scm_filename);

#endif
