;;; mr-oxford.scm: Remembers and completes all known words from
;;;               disctionary and what ever you have typed.
;;; author: Anand Babu. Scheme primitive by Anand Avati.

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

(use-modules (ice-9 rdelim))


(display "Loading words from sorted dictionary [/usr/share/dict/words]... ")
(catch 'system-error
       (lambda ()
	 (for-each-line (lambda (word)
			  (fh-dict-add-word-sorted! word))
			"/usr/share/dict/words"))
       (lambda args #f))
(display "done.\n")

;; Add sent-words to readline context"
(add-hook! fh-message-send-hook 
	   (lambda (to msg)
	     (map fh-dict-add-word! (sentence->words msg))))




