;;; file freehoo.scm: example freehoo startup file

;   this is comment
;;; sample freehoo.scm
;;; login-id is equal to my gnu/linux account
;; (fh-set-default-login-id! (getlogin))

;;; default login-id for yahoo service
(fh-set-default-login-id! "gnu_india")
;; (fh-set-default-login-id! "abindian")
;; (fh-set-default-login-id! "gnubot")

;;; default global password
(fh-set-default-password! "nopassword")
;; (fh-set-default-password! "pressenter")

;;; by default session mode is AUTO-INSERT. switch it to VANILLA mode
;; (fh-toggle! "session")

;;; by default display of status message is ON. switch it OFF
;; (fh-toggle! "status")

;;; if login-id is "abindian"
(and (string=? (fh-get-default-login-id) "abindian")
     ;;; default password
     (fh-set-default-password! "pressenter")
     ;;; switch OFF bell
     (fh-toggle! "bell")
     ;;; show ALL buddies
     (fh-toggle! "who")
     ;;; login in invisible mode
     (fh-set-default-status! 12))

;;; if login-id is "gnubot"
(and (string=? (fh-get-default-login-id) "gnubot")
     ;;; default password
     (fh-set-default-password! "pressescape")
     ;;; switch OFF bell
     (fh-toggle! "bell"))

;;; create aliases
(define alias '((helpdesk . (abindian balugi kvisu2000))
                (mridul . (gnuindian))
                (bala . (balugi))
                (nags . (nagappanal))
                (visu . (kvisu2000))))

;;; create CC lists
(define cc '((rms . (markus roland thomas))
             (gopal_narayanan . (parag_mehta))))

;;; create forward lists
(define forward '((gnubot . (ramyog_2000 nagappanal balugi))
                 (gopal_narayanan . (parag_mehta))))


;;; add custom words for dictionary autocomplete
(fh-dict-add-word! "freehoo")
(fh-dict-add-word! "my1337n1c|<")
