;;; hacker-romance.scm: extensible romance :p
;;; author: Anand Babu <ab@zresearch.com>
;;; Copyright 2006 Z RESEARCH Inc. 

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; this extension is should be automatically loaded thru init.scm

(define min-chars 3)
(define max-chars 33)

(define rand-state (seed->random-state (current-time)))

(define (burst-of-romance buddy count message)
  "burst of MESSAGEs to BUDDY"
  (fh-send-message buddy message)
  (if (= count 1)
      '()
      (begin
	(sleep (+ 1 (random 3 (seed->random-state (current-time)))))
	(burst-of-romance buddy (- count 1) message)
	)))

;;; Dynamic command support
(fh-register-command!
 '("/burst-of-romance"
   "/burst-of-romance BUDDY COUNT MESSAGE\n\t- burst of MESSAGEs to BUDDY"))

(define (/burst-of-romance args-list)
  (set! args-list (list->strlist args-list))
  (if (= (length args-list) 3)
      (burst-of-romance (list-ref args-list 0) 
			 (string->number (list-ref args-list 1))
			 (list-ref args-list 2))
      (begin
	(display "/burst-of-romance: wrong number of arguments\n")
	(display "usage: burst-of-romance BUDDY COUNT MESSAGE \n"))))

(define (nstr str count)
  "return COUNT number of CHARs"
  (if (string=? str " ")
      " "
      (if (> count 0)
	  (string-append (nstr str (- count 1)) str)
	  "")))

(define (burst str min max)
  "explode the STR string with MIN and MAX character count"
  (if (string-null? str)
      ""
      (begin
        (string-append
	  (nstr (list->string (list (car (string->list str)))) 
	        (+ min (random max rand-state)))
	  (burst (list->string (cdr (string->list str))) min max)))))

(define (/burst args)
  "send burst of chars"
  (let
      ((args (list->strlist args)))
    (if (>= (length args) 2)
	(begin
	  (fh-send-message-no-hook (car args)
	                           (burst (list->asv (cdr args) " ")
 				   	  min-chars
				          max-chars))
          (fh-set-current-target-buddy! (car args) "send"))
        (begin
          (display "/burst: wrong number of arguments\n")
          (display "usage: /burst BUDDY MESSAGE\n")))))

(fh-register-command! '("/burst" "/burst BUDDY MESSAGE\n\t- Send burst of chars"))
