// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef BTMIO_H
#define BTMIO_H

#include <stdbool.h>
#include <stdio.h>
#include <sys/types.h>

#define BZSTREAMSIZE 2048

typedef void BZFILE;

typedef struct
{
  char buffer[BZSTREAMSIZE];
  int pos;
  int read;
  bool eof;
  BZFILE *file;
} BZSTREAM;

typedef struct
{
  FILE *raw;
  BZFILE *compressed;
} BTMFILE;


BTMFILE
*btmfopenread(const char *filename);

void
btmfclose(BTMFILE *file);

int
btmfgetc(BTMFILE *file);

void
btmungetc(int c, BTMFILE *file);

ssize_t
btmgetline(char **line, size_t *n, BTMFILE *file);

#endif
