// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "list.h"

void
list_free(list *a)
{
	list *ta = a, *tb;
	while(ta)
	{
		tb = ta->next;
		free(ta);
		ta = tb;
	}
}

list *
list_index(list *a, size_t i)
{
	list *t = a;
	size_t s;
	for(s = 0; s < i; s++)
		t = t->next;
	return t;
}

list *
list_last(list *a)
{
	if(a)
	{
		list *t = a;
		while(t->next)
			t = t->next;
		return t;
	}
	else return a;
}

size_t
list_length(const list *a)
{
	size_t s = 0;
	const list *t;
	for(t = a; t; t = t->next)
		s++;
	return s;
}

list *
list_append(list *a, void *data)
{
	if(a)
	{
		list *t = list_last(a);
		t->next = malloc(sizeof(list));
		t->next->next = NULL;
		t->next->data = data;
	}
	else
	{
		a = malloc(sizeof(list));
		a->next = NULL;
		a->data = data;
	}
	return a;
}

list *
list_insert(list *a, size_t i, void *data)
{
	if(i)
	{
		list *t, *tn;
	       	t = list_index(a, i - 1);
		tn = t->next;
		t->next = malloc(sizeof(list));
		t->next->next = tn;
		t->next->data = data;
		return a;

	}
	else return list_prepend(a, data);
}

list *
list_prepend(list *a, void *data)
{
	if(a)
	{
		list *t = a;
		a = malloc(sizeof(list));
		a->next = t;
		a->data = data;
	}
	else
	{
		a = malloc(sizeof(list));
		a->next = NULL;
		a->data = data;
	}
	return a;
}

list *
list_remove(list *a, size_t i)
{
	if(i)
	{
		list *ta = list_index(a, i - 1);
		list *tb = ta->next->next;
		free(ta->next);
		ta->next = tb;
		return a;
	}
	else
	{
		list *t;
		t = a->next;
		free(a);
		return t;
	}
}

void
list_scan(list *a, list_scanner scanner)
{
	list *t;
	for(t = a; t; t = t->next)
		scanner(t->data);
}

void
list_user_scan(list *a, list_user_scanner scanner, void *data)
{
	list *t;
	for(t = a; t; t = t->next)
		scanner(t->data, data);
}

