// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _ML_H_
#define _ML_H_

// Vector

void
mlVectorRepr(const float *a, char *repr);

void
mlVectorPrint(const float *a);

void
mlVectorCopy(const float *a, float *result);

void
mlVectorLoad(float *a, float x, float y, float z);

void
mlVectorAdd(const float *a, const float *b, float *result);

void
mlVectorAddInPlace(float *a, const float *b);

void
mlVectorSub(const float *a, const float *b, float *result);

void
mlVectorSubInPlace(float *a, const float *b);

void
mlVectorScalarProduct(const float *a, float b, float *result);

void
mlVectorScalarProductInPlace(float *a, float b);

void
mlVectorNorm(const float *a, float *result);

float
mlVectorNormFunc(const float *a);

void
mlVectorDotProduct(const float *a, const float *b, float *result);

float
mlVectorDotProductFunc(const float *a, const float *b);

void
mlVectorCrossProduct(const float *a, const float *b, float *result);

void
mlVectorCrossProductInPlace(float *a, const float *b);

void
mlVectorNormal(const float *a, float *result);

void
mlVectorNormalInPlace(float *a);

void
mlVectorMatrixProduct(const float *a, const float *b, float *result);

void
mlVectorMatrixProductInPlace(float *a, const float *b);

void
mlVectorRotate(const float *a, const float *axis, float angle, float *result);

void
mlVectorRotateInPlace(float *a, const float *axis, float angle);

void
mlVectorAngle(const float *a, const float *b, float *angle);

float
mlVectorAngleFunc(const float *a, const float *b);

#define mlVectorLoadX(a) mlVectorLoad(a, 1, 0, 0)
#define mlVectorLoadY(a) mlVectorLoad(a, 0, 1, 0)
#define mlVectorLoadZ(a) mlVectorLoad(a, 0, 0, 1)
#define mlVectorLoadNegX(a) mlVectorLoad(a, -1, 0, 0)
#define mlVectorLoadNegY(a) mlVectorLoad(a, 0, -1, 0)
#define mlVectorLoadNegZ(a) mlVectorLoad(a, 0, 0, -1)

extern float mlPointZero[3];
extern float mlVectorX[3];
extern float mlVectorY[3];
extern float mlVectorZ[3];
extern float mlVectorNegX[3];
extern float mlVectorNegY[3];
extern float mlVectorNegZ[3];

// Point

#define mlPointRepr mlVectorRepr
#define mlPointPrint mlVectorPrint
#define mlPointCopy mlVectorCopy
#define mlPointLoad mlVectorLoad
#define mlPointLoadOrigin(a) mlPointLoad(a, 0, 0, 0)
#define mlPointAdd mlVectorAdd
#define mlPointSub mlVectorSub
#define mlPointLoadO(a) mlPointLoad(a, 0, 0, 0)

// Matrix

void
mlMatrixRepr(const float *a, char *repr);

void
mlMatrixPrint(const float *a);

void
mlMatrixCopy(const float *a, float *result);

void
mlMatrixLoad(float *x, float a, float b, float c, float d, float e, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p);

void
mlMatrixLoadIdentity(float *a);

void
mlMatrixAdd(const float *a, const float *b, float *result);

void
mlMatrixAddInPlace(float *a, const float *b);

void
mlMatrixSub(const float *a, const float *b, float *result);

void
mlMatrixSubInPlace(float *a, const float *b);

void
mlMatrixScalarProduct(const float *a, float b, float *result);

void
mlMatrixScalarProductInPlace(float *a, float b);

void
mlMatrixProduct(const float *a, const float *b, float *result);

void
mlMatrixTranspose(const float *a, float *result);

void
mlMatrixTransposeInPlace(float *a);

void
mlMatrixScale(const float *a, const float *b, float *result);

void
mlMatrixScaleInPlace(float *a, const float *b);

void
mlMatrixRotate(const float *a, const float *axis, float angle, float *result);

void
mlMatrixRotateInPlace(float *a, const float *axis, float angle);

void
mlMatrixTranslate(const float *a, const float *b, float *result);

void
mlMatrixTranslateInPlace(float *a, const float *b);

void
mlMatrixLookAt(float *eye, float *center, float *up, float *result);

void
mlMatrixLook(float *position, float *forward, float *up, float *result);

void
mlMatrixGetPosition(const float *a, float *result);

void
mlMatrixGetRight(const float *a, float *result);

void
mlMatrixGetUp(const float *a, float *result);

void
mlMatrixGetForward(const float *a, float *result);

void
mlMatrixGetEscalation(const float *a, float *result);

void
mlMatrixGetRotation(const float *a, float *result);

void
mlMatrixGetTranslation(const float *a, float *result);

// Object

void
mlObjectRepr(const float *a, char *repr);

void
mlObjectPrint(const float *a);

void
mlObjectCopy(float *a, float *result);

void
mlObjectLoad(float *x, float a, float b, float c, float d, float e, float f, float g, float h, float i, float j, float k, float l);

void
mlObjectLoadv(float *a, const float *p, const float *f, const float *u, const float *r);

void
mlObjectLoadIdentity(float *a);

// Sphere

void
mlSphereRepr(const float *a, char *repr);

void
mlSpherePrint(const float *a);

void
mlSphereCopy(const float *a, float *result);

void
mlSphereLoad(float *a, float x, float y, float z, float r);

void
mlSphereMerge(const float *a, const float *b, float *result);

void
mlSphereMergeInPlace(float *a, const float *b);

// Triangle

void
mlTriangleRepr(const float *a, char *repr);

void
mlTrianglePrint(const float *a);

void
mlTriangleCopy(const float *a, float *result);

void
mlTriangleGetBoundSphere(const float *a, float *result);

/*
void
mlTriangleIsInCube(const float *a, const float *cube);
*/

// Util

float
mlClampf(float x, float a, float b);

int
mlClampi(int x, int a, int b);

#endif
