// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include "ML/ml.h"
#include <stdio.h>
#include <string.h>
#include <math.h>

void
mlSphereRepr(const float *a, char *repr)
{
	if(asprintf(&repr, "[(%f, %f, %f), %f]", a[0], a[1], a[2], a[3])<0)
		repr = NULL;
}

void
mlSpherePrint(const float *a)
{
	printf("[(%f, %f, %f), %f]\n", a[0], a[1], a[2], a[3]);
}

void
mlSphereCopy(const float *a, float *result)
{
	memcpy(result, a, 4 * sizeof(float));
}

void
mlSphereLoad(float *a, float x, float y, float z, float r)
{
	a[0] = x;
	a[1] = y;
	a[2] = z;
	a[3] = r;
}

void
mlSphereMerge(const float *a, const float *b, float *result)
{
	float distancer[3];
	float distance;
	distancer[0] = b[0] - a[0];
	distancer[1] = b[1] - a[1];
	distancer[2] = b[2] - a[2];
	distance = sqrt(powf(distancer[0], 2) + powf(distancer[1], 2) + powf(distancer[2], 2));
	if(distance + b[3] > a[3])
	{
		if(distance + a[3] > b[3])
		{
			distancer[0] /= distance;
			distancer[1] /= distance;
			distancer[2] /= distance;
			result[3] = (distance + a[3] + b[3]) / 2.0;
			result[0] = a[0] + distancer[0] * (result[3] - a[3]);
			result[1] = a[1] + distancer[1] * (result[3] - a[3]);
			result[2] = a[2] + distancer[2] * (result[3] - a[3]);
		}
		else
			mlSphereCopy(b, result);
	}
	else
		mlSphereCopy(a, result);
}

void
mlSphereMergeInPlace(float *a, const float *b)
{
	float result[4];
	mlSphereMerge(a, b, result);
	mlSphereCopy(result, a);
}
