// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "set.h"

void
set_free(set *a)
{
	list_free(a);
}

size_t
set_size(const set *a)
{
	return list_length(a);
}

bool
set_contains(set *a, void *data)
{
	if(a)
	{
		list *t;
		for(t = a; t && t->data != data; t = t->next)
			;
		return t;
	}
	else return false;
}

set *
set_add(set *a, void *data)
{
	if(set_contains(a, data)) return a;
	else return list_prepend(a, data);
}

set *
set_remove(set *a, void *data)
{
	if(a)
	{
		list *t;
		size_t i;
		for(t = a, i = 0; t && t->data != data; t = t->next, i++)
			;
		return list_remove(a, i);
	}
	else return a;
}

