// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "H3D/Sound.h"
#include <stdlib.h>
#include <string.h>
#include <magic.h>
#include <vorbis/vorbisfile.h>

namespace H3D
{
	namespace Sound
	{
		H3D::H3D(void)
		{
			info.magic = 0;
		}

		H3D::~H3D(void)
		{
		}

		bool
		H3D::load(const std::string& filename)
		{
			FILE* stream;
			bool result;
			stream = fopen(filename.c_str(), "rb");
			if(stream)
			{
				fread(&info, 1, sizeof(Info), stream);
				content.samples = new short[info.nframes * info.nchannels];
				fread(content.samples, 1, info.nframes * info.nchannels * sizeof(short), stream);
				fclose(stream);
				result = true;
			}
			else result = false;
			return result;
		}

		void
		H3D::unload(void)
		{
			delete content.samples;
		}

		bool
		H3D::save(const std::string& filename)
		{
			FILE* stream;
			bool result;
			stream = fopen(filename.c_str(), "wb");
			if(stream)
			{
				fwrite(&info, 1, sizeof(Info), stream);
				fwrite(content.samples, 1, info.nframes * info.nchannels * sizeof(short), stream);
				fclose(stream);
				result = true;
			}
			else result = false;
			return result;
		}

		namespace VORBIS
		{
			H3D*
			import(const std::string& filename)
			{
				H3D* sound;
				FILE *stream;
				OggVorbis_File ogg;
				int bitstream;
				unsigned int bytes, read;
				vorbis_info *vorbis;
				stream = fopen(filename.c_str(), "rb");
				if(stream)
				{
					if(ov_open(stream, &ogg, NULL, 0) == 0)
					{
						sound = new H3D();
						vorbis = ov_info(&ogg, -1);
						sound->info.rate = vorbis->rate;
						sound->info.nchannels = vorbis->channels;
						sound->info.nframes = (unsigned int) ov_pcm_total(&ogg, -1);
						sound->content.samples = new short[sound->info.nframes * sound->info.nchannels];
						read = 0;
						do
						{
							bytes = ov_read(&ogg, (char*) sound->content.samples + read, sound->info.nframes * sound->info.nchannels * sizeof(short) - read, 0, 2, 1, &bitstream);
							read += bytes;
						}	
						while(read < sound->info.nframes * sound->info.nchannels * sizeof(short) && bytes > 0);
						ov_clear(&ogg);
					}
					else
					{
						fclose(stream);
						sound = NULL;
					}
				}
				else sound = NULL;
				return sound;
			}
		}

		namespace MIME
		{
			H3D*
			import(const std::string& filename)
			{
				H3D* sound;
				magic_t cookie;
				const char *mime;
				cookie = magic_open(MAGIC_MIME_TYPE |MAGIC_NO_CHECK_COMPRESS | MAGIC_NO_CHECK_TAR);
				magic_load(cookie, NULL);
				mime = magic_file(cookie, filename.c_str());
				if(!strcmp(mime, "application/ogg")) sound = VORBIS::import(filename);
				else sound = NULL;
				magic_close(cookie);
				return sound;
			}
		}

		namespace NAME
		{
			H3D*
			import(const std::string& filename)
			{
				H3D* sound;
				if(!(sound = VORBIS::import(filename + ".ogg")))
					sound = VORBIS::import(filename + ".oga");
				return sound;
			}
		}
	}
}
