// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "MyTrack.h"

MyTrack::MyTrack(void)
{
	mesh = new H3D::Helper::Mesh::H3D();
}

MyTrack::~MyTrack(void)
{
	delete mesh;
}

bool
MyTrack::load(const std::string &track, dSpaceID space)
{

	mesh->load(PACKAGE_DATADIR STRPS + track);
	mesh->glLoad(PACKAGE_DATADIR STRPS "textures");
	mesh->deLoad(space);
	MyCheckPoints::load(PACKAGE_DATADIR STRPS "checkpoints" STRPS + track);
	//MyCheckPoints::load(PACKAGE_DATADIR STRPS "checkpoints" STRPS + track + ".ckp", false);
	//MyCheckPoints::save(PACKAGE_DATADIR STRPS "checkpoints" STRPS + track);
	////MyCheckPoints::save(PACKAGE_DATADIR STRPS "checkpoints" STRPS + track + ".txt", false);
	return true;
}

void
MyTrack::unload(void)
{
	mesh->deUnload();
	mesh->glUnload();
	mesh->unload();
}

void
MyTrack::frame(void)
{
	mesh->draw();
}

