// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#pragma once

#include <ode/ode.h>
#include <H3D/H3D.h>

class MyWidget:
	public H3D::Helper::Mesh::H3D
{
	public:
		dBodyID body;

		MyWidget();

		virtual
		~MyWidget();

		virtual
		bool
		load(dWorldID world = NULL, dSpaceID space = NULL) = 0;

		virtual
		void
		unload(void) = 0;

		virtual
		void
		frame(void);

		virtual
		void
		enable(void);

		virtual
		void
		disable(void);

		virtual
		void
		place(const float *position);
};

class MyCube:
	public MyWidget
{
	public:
		MyCube();

		virtual
		~MyCube();

		bool
		load(dWorldID world, dSpaceID space);

		void
		unload(void);

		void
		frame(void);

		void
		enable(void);

		void
		disable(void);

		void
		place(const float *position);
};

class MyTurbo:
	public MyWidget
{
	public:
		MyTurbo();

		virtual
		~MyTurbo();

		bool
		load(dWorldID world = NULL, dSpaceID space = NULL);

		void
		unload(void);
};

class MyFake:
	public MyWidget
{
	public:
		MyFake();

		virtual
		~MyFake();

		bool
		load(dWorldID world = NULL, dSpaceID space = NULL);

		void
		unload(void);
};
