!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRp0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(2,38)
      V(2)=r1x2E*ZxZpE*VRR1(2,38)
      V(3)=r1x2E*VRR0(2,39)
      V(4)=HfxZpE*VRR1(1,60)
      V(5)=r1x2E*ZxZpE*VRR1(2,39)
      V(6)=r1x2E*VRR0(2,44)
      V(7)=3.D0*V(6)
      V(8)=r1x2E*ZxZpE*VRR1(2,44)
      V(9)=-3.D0*V(8)
      V(10)=r1x2E*VRR0(2,45)
      V(11)=HfxZpE*VRR1(1,67)
      V(12)=r1x2E*ZxZpE*VRR1(2,45)
      V(13)=r1x2E*VRR0(2,47)
      V(14)=r1x2E*ZxZpE*VRR1(2,47)
      V(15)=r1x2E*VRR0(2,48)
      V(16)=3.D0*V(15)
      V(17)=r1x2E*ZxZpE*VRR1(2,48)
      V(18)=-3.D0*V(17)
      V(19)=r1x2E*VRR0(2,49)
      V(20)=HfxZpE*VRR1(1,72)
      V(21)=r1x2E*ZxZpE*VRR1(2,49)
      V(22)=3.D0*V(19)
      V(23)=-3.D0*V(21)
      V(24)=r1x2E*VRR0(2,50)
      V(25)=r1x2E*ZxZpE*VRR1(2,50)
      V(26)=r1x2E*VRR0(2,51)
      V(27)=HfxZpE*VRR1(1,75)
      V(28)=r1x2E*ZxZpE*VRR1(2,51)
      V(29)=r1x2E*VRR0(2,52)
      V(30)=2.D0*V(29)
      V(31)=HfxZpE*VRR1(1,76)
      V(32)=r1x2E*ZxZpE*VRR1(2,52)
      V(33)=-2.D0*V(32)
      V(34)=r1x2E*VRR0(2,53)
      V(35)=r1x2E*ZxZpE*VRR1(2,53)
      V(36)=r1x2E*VRR0(3,38)
      V(37)=r1x2E*ZxZpE*VRR1(3,38)
      V(38)=r1x2E*VRR0(3,39)
      V(39)=r1x2E*ZxZpE*VRR1(3,39)
      V(40)=r1x2E*VRR0(3,44)
      V(41)=3.D0*V(40)
      V(42)=r1x2E*ZxZpE*VRR1(3,44)
      V(43)=-3.D0*V(42)
      V(44)=r1x2E*VRR0(3,45)
      V(45)=r1x2E*ZxZpE*VRR1(3,45)
      V(46)=r1x2E*VRR0(3,47)
      V(47)=r1x2E*ZxZpE*VRR1(3,47)
      V(48)=r1x2E*VRR0(3,48)
      V(49)=3.D0*V(48)
      V(50)=r1x2E*ZxZpE*VRR1(3,48)
      V(51)=-3.D0*V(50)
      V(52)=r1x2E*VRR0(3,49)
      V(53)=r1x2E*ZxZpE*VRR1(3,49)
      V(54)=3.D0*V(52)
      V(55)=-3.D0*V(53)
      V(56)=r1x2E*VRR0(3,50)
      V(57)=r1x2E*ZxZpE*VRR1(3,50)
      V(58)=r1x2E*VRR0(3,51)
      V(59)=r1x2E*ZxZpE*VRR1(3,51)
      V(60)=r1x2E*VRR0(3,52)
      V(61)=2.D0*V(60)
      V(62)=r1x2E*ZxZpE*VRR1(3,52)
      V(63)=-2.D0*V(62)
      V(64)=HfxZpE*VRR1(1,77)
      V(65)=r1x2E*VRR0(3,53)
      V(66)=HfxZpE*VRR1(1,78)
      V(67)=r1x2E*ZxZpE*VRR1(3,53)
      V(68)=r1x2E*VRR0(4,38)
      V(69)=r1x2E*ZxZpE*VRR1(4,38)
      V(70)=r1x2E*VRR0(4,39)
      V(71)=r1x2E*ZxZpE*VRR1(4,39)
      V(72)=r1x2E*VRR0(4,44)
      V(73)=3.D0*V(72)
      V(74)=r1x2E*ZxZpE*VRR1(4,44)
      V(75)=-3.D0*V(74)
      V(76)=r1x2E*VRR0(4,45)
      V(77)=r1x2E*ZxZpE*VRR1(4,45)
      V(78)=r1x2E*VRR0(4,47)
      V(79)=r1x2E*ZxZpE*VRR1(4,47)
      V(80)=r1x2E*VRR0(4,48)
      V(81)=3.D0*V(80)
      V(82)=r1x2E*ZxZpE*VRR1(4,48)
      V(83)=-3.D0*V(82)
      V(84)=r1x2E*VRR0(4,49)
      V(85)=r1x2E*ZxZpE*VRR1(4,49)
      V(86)=3.D0*V(84)
      V(87)=-3.D0*V(85)
      V(88)=r1x2E*VRR0(4,50)
      V(89)=r1x2E*ZxZpE*VRR1(4,50)
      V(90)=r1x2E*VRR0(4,51)
      V(91)=r1x2E*ZxZpE*VRR1(4,51)
      V(92)=r1x2E*VRR0(4,52)
      V(93)=2.D0*V(92)
      V(94)=r1x2E*ZxZpE*VRR1(4,52)
      V(95)=-2.D0*V(94)
      V(96)=r1x2E*VRR0(4,53)
      V(97)=r1x2E*ZxZpE*VRR1(4,53)
      VRR0(2,85)=6.D0*r1x2E*VRR0(2,36)+QCx*VRR0(2,57)+HfxZpE*VRR1(1,57)-6.D0*r1x2E*ZxZpE*VRR1(2,36)+WQx*VRR1(2,57)
      VRR0(2,86)=5.D0*r1x2E*VRR0(2,37)+QCx*VRR0(2,58)+HfxZpE*VRR1(1,58)-5.D0*r1x2E*ZxZpE*VRR1(2,37)+WQx*VRR1(2,58)
      VRR0(2,87)=4.D0*V(1)-4.D0*V(2)+QCx*VRR0(2,59)+HfxZpE*VRR1(1,59)+WQx*VRR1(2,59)
      VRR0(2,88)=3.D0*V(3)+V(4)-3.D0*V(5)+QCx*VRR0(2,60)+WQx*VRR1(2,60)
      VRR0(2,89)=3.D0*V(1)-3.D0*V(2)+QCy*VRR0(2,60)+WQy*VRR1(2,60)
      VRR0(2,90)=4.D0*V(3)-4.D0*V(5)+QCy*VRR0(2,61)+WQy*VRR1(2,61)
      VRR0(2,91)=5.D0*r1x2E*VRR0(2,40)+QCy*VRR0(2,62)-5.D0*r1x2E*ZxZpE*VRR1(2,40)+WQy*VRR1(2,62)
      VRR0(2,92)=6.D0*r1x2E*VRR0(2,41)+QCy*VRR0(2,63)-6.D0*r1x2E*ZxZpE*VRR1(2,41)+WQy*VRR1(2,63)
      VRR0(2,93)=5.D0*r1x2E*VRR0(2,42)+QCx*VRR0(2,64)+HfxZpE*VRR1(1,64)-5.D0*r1x2E*ZxZpE*VRR1(2,42)+WQx*VRR1(2,64)
      VRR0(2,94)=4.D0*r1x2E*VRR0(2,43)+QCx*VRR0(2,65)+HfxZpE*VRR1(1,65)-4.D0*r1x2E*ZxZpE*VRR1(2,43)+WQx*VRR1(2,65)
      VRR0(2,95)=V(7)+V(9)+QCx*VRR0(2,66)+HfxZpE*VRR1(1,66)+WQx*VRR1(2,66)
      VRR0(2,96)=2.D0*V(10)+V(11)-2.D0*V(12)+QCx*VRR0(2,67)+WQx*VRR1(2,67)
      VRR0(2,97)=V(7)+V(9)+QCy*VRR0(2,67)+WQy*VRR1(2,67)
      VRR0(2,98)=4.D0*V(10)-4.D0*V(12)+QCy*VRR0(2,68)+WQy*VRR1(2,68)
      VRR0(2,99)=5.D0*r1x2E*VRR0(2,46)+QCy*VRR0(2,69)-5.D0*r1x2E*ZxZpE*VRR1(2,46)+WQy*VRR1(2,69)
      VRR0(2,100)=4.D0*V(13)-4.D0*V(14)+QCx*VRR0(2,70)+HfxZpE*VRR1(1,70)+WQx*VRR1(2,70)
      VRR0(2,101)=V(16)+V(18)+QCx*VRR0(2,71)+HfxZpE*VRR1(1,71)+WQx*VRR1(2,71)
      VRR0(2,102)=2.D0*V(19)+V(20)-2.D0*V(21)+QCx*VRR0(2,72)+WQx*VRR1(2,72)
      VRR0(2,103)=2.D0*V(15)-2.D0*V(17)+QCy*VRR0(2,72)+WQy*VRR1(2,72)
      VRR0(2,104)=V(22)+V(23)+QCy*VRR0(2,73)+WQy*VRR1(2,73)
      VRR0(2,105)=4.D0*V(24)-4.D0*V(25)+QCy*VRR0(2,74)+WQy*VRR1(2,74)
      VRR0(2,106)=3.D0*V(26)+V(27)-3.D0*V(28)+QCx*VRR0(2,75)+WQx*VRR1(2,75)
      VRR0(2,107)=V(30)+V(31)+V(33)+QCx*VRR0(2,76)+WQx*VRR1(2,76)
      VRR0(2,108)=2.D0*V(6)-2.D0*V(8)+QCz*VRR0(2,72)+WQz*VRR1(2,72)
      VRR0(2,109)=V(30)+V(33)+QCy*VRR0(2,77)+WQy*VRR1(2,77)
      VRR0(2,110)=3.D0*V(34)-3.D0*V(35)+QCy*VRR0(2,78)+WQy*VRR1(2,78)
      VRR0(2,111)=3.D0*V(13)-3.D0*V(14)+QCz*VRR0(2,75)+WQz*VRR1(2,75)
      VRR0(2,112)=V(16)+V(18)+QCz*VRR0(2,76)+WQz*VRR1(2,76)
      VRR0(2,113)=V(22)+V(23)+QCz*VRR0(2,77)+WQz*VRR1(2,77)
      VRR0(2,114)=3.D0*V(24)-3.D0*V(25)+QCz*VRR0(2,78)+WQz*VRR1(2,78)
      VRR0(2,115)=4.D0*V(26)-4.D0*V(28)+QCz*VRR0(2,79)+WQz*VRR1(2,79)
      VRR0(2,116)=4.D0*V(29)-4.D0*V(32)+QCz*VRR0(2,80)+WQz*VRR1(2,80)
      VRR0(2,117)=4.D0*V(34)-4.D0*V(35)+QCz*VRR0(2,81)+WQz*VRR1(2,81)
      VRR0(2,118)=5.D0*r1x2E*VRR0(2,54)+QCz*VRR0(2,82)-5.D0*r1x2E*ZxZpE*VRR1(2,54)+WQz*VRR1(2,82)
      VRR0(2,119)=5.D0*r1x2E*VRR0(2,55)+QCz*VRR0(2,83)-5.D0*r1x2E*ZxZpE*VRR1(2,55)+WQz*VRR1(2,83)
      VRR0(2,120)=6.D0*r1x2E*VRR0(2,56)+QCz*VRR0(2,84)-6.D0*r1x2E*ZxZpE*VRR1(2,56)+WQz*VRR1(2,84)
      VRR0(3,85)=6.D0*r1x2E*VRR0(3,36)+QCx*VRR0(3,57)-6.D0*r1x2E*ZxZpE*VRR1(3,36)+WQx*VRR1(3,57)
      VRR0(3,86)=5.D0*r1x2E*VRR0(3,37)+QCx*VRR0(3,58)-5.D0*r1x2E*ZxZpE*VRR1(3,37)+WQx*VRR1(3,58)
      VRR0(3,87)=4.D0*V(36)-4.D0*V(37)+QCx*VRR0(3,59)+WQx*VRR1(3,59)
      VRR0(3,88)=3.D0*V(38)-3.D0*V(39)+QCx*VRR0(3,60)+WQx*VRR1(3,60)
      VRR0(3,89)=V(4)+3.D0*V(36)-3.D0*V(37)+QCy*VRR0(3,60)+WQy*VRR1(3,60)
      VRR0(3,90)=4.D0*V(38)-4.D0*V(39)+QCy*VRR0(3,61)+HfxZpE*VRR1(1,61)+WQy*VRR1(3,61)
      VRR0(3,91)=5.D0*r1x2E*VRR0(3,40)+QCy*VRR0(3,62)+HfxZpE*VRR1(1,62)-5.D0*r1x2E*ZxZpE*VRR1(3,40)+WQy*VRR1(3,62)
      VRR0(3,92)=6.D0*r1x2E*VRR0(3,41)+QCy*VRR0(3,63)+HfxZpE*VRR1(1,63)-6.D0*r1x2E*ZxZpE*VRR1(3,41)+WQy*VRR1(3,63)
      VRR0(3,93)=5.D0*r1x2E*VRR0(3,42)+QCx*VRR0(3,64)-5.D0*r1x2E*ZxZpE*VRR1(3,42)+WQx*VRR1(3,64)
      VRR0(3,94)=4.D0*r1x2E*VRR0(3,43)+QCx*VRR0(3,65)-4.D0*r1x2E*ZxZpE*VRR1(3,43)+WQx*VRR1(3,65)
      VRR0(3,95)=V(41)+V(43)+QCx*VRR0(3,66)+WQx*VRR1(3,66)
      VRR0(3,96)=2.D0*V(44)-2.D0*V(45)+QCx*VRR0(3,67)+WQx*VRR1(3,67)
      VRR0(3,97)=V(11)+V(41)+V(43)+QCy*VRR0(3,67)+WQy*VRR1(3,67)
      VRR0(3,98)=4.D0*V(44)-4.D0*V(45)+QCy*VRR0(3,68)+HfxZpE*VRR1(1,68)+WQy*VRR1(3,68)
      VRR0(3,99)=5.D0*r1x2E*VRR0(3,46)+QCy*VRR0(3,69)+HfxZpE*VRR1(1,69)-5.D0*r1x2E*ZxZpE*VRR1(3,46)+WQy*VRR1(3,69)
      VRR0(3,100)=4.D0*V(46)-4.D0*V(47)+QCx*VRR0(3,70)+WQx*VRR1(3,70)
      VRR0(3,101)=V(49)+V(51)+QCx*VRR0(3,71)+WQx*VRR1(3,71)
      VRR0(3,102)=2.D0*V(52)-2.D0*V(53)+QCx*VRR0(3,72)+WQx*VRR1(3,72)
      VRR0(3,103)=V(20)+2.D0*V(48)-2.D0*V(50)+QCy*VRR0(3,72)+WQy*VRR1(3,72)
      VRR0(3,104)=V(54)+V(55)+QCy*VRR0(3,73)+HfxZpE*VRR1(1,73)+WQy*VRR1(3,73)
      VRR0(3,105)=4.D0*V(56)-4.D0*V(57)+QCy*VRR0(3,74)+HfxZpE*VRR1(1,74)+WQy*VRR1(3,74)
      VRR0(3,106)=3.D0*V(58)-3.D0*V(59)+QCx*VRR0(3,75)+WQx*VRR1(3,75)
      VRR0(3,107)=V(61)+V(63)+QCx*VRR0(3,76)+WQx*VRR1(3,76)
      VRR0(3,108)=2.D0*V(40)-2.D0*V(42)+QCz*VRR0(3,72)+WQz*VRR1(3,72)
      VRR0(3,109)=V(61)+V(63)+V(64)+QCy*VRR0(3,77)+WQy*VRR1(3,77)
      VRR0(3,110)=3.D0*V(65)+V(66)-3.D0*V(67)+QCy*VRR0(3,78)+WQy*VRR1(3,78)
      VRR0(3,111)=3.D0*V(46)-3.D0*V(47)+QCz*VRR0(3,75)+WQz*VRR1(3,75)
      VRR0(3,112)=V(49)+V(51)+QCz*VRR0(3,76)+WQz*VRR1(3,76)
      VRR0(3,113)=V(54)+V(55)+QCz*VRR0(3,77)+WQz*VRR1(3,77)
      VRR0(3,114)=3.D0*V(56)-3.D0*V(57)+QCz*VRR0(3,78)+WQz*VRR1(3,78)
      VRR0(3,115)=4.D0*V(58)-4.D0*V(59)+QCz*VRR0(3,79)+WQz*VRR1(3,79)
      VRR0(3,116)=4.D0*V(60)-4.D0*V(62)+QCz*VRR0(3,80)+WQz*VRR1(3,80)
      VRR0(3,117)=4.D0*V(65)-4.D0*V(67)+QCz*VRR0(3,81)+WQz*VRR1(3,81)
      VRR0(3,118)=5.D0*r1x2E*VRR0(3,54)+QCz*VRR0(3,82)-5.D0*r1x2E*ZxZpE*VRR1(3,54)+WQz*VRR1(3,82)
      VRR0(3,119)=5.D0*r1x2E*VRR0(3,55)+QCz*VRR0(3,83)-5.D0*r1x2E*ZxZpE*VRR1(3,55)+WQz*VRR1(3,83)
      VRR0(3,120)=6.D0*r1x2E*VRR0(3,56)+QCz*VRR0(3,84)-6.D0*r1x2E*ZxZpE*VRR1(3,56)+WQz*VRR1(3,84)
      VRR0(4,85)=6.D0*r1x2E*VRR0(4,36)+QCx*VRR0(4,57)-6.D0*r1x2E*ZxZpE*VRR1(4,36)+WQx*VRR1(4,57)
      VRR0(4,86)=5.D0*r1x2E*VRR0(4,37)+QCx*VRR0(4,58)-5.D0*r1x2E*ZxZpE*VRR1(4,37)+WQx*VRR1(4,58)
      VRR0(4,87)=4.D0*V(68)-4.D0*V(69)+QCx*VRR0(4,59)+WQx*VRR1(4,59)
      VRR0(4,88)=3.D0*V(70)-3.D0*V(71)+QCx*VRR0(4,60)+WQx*VRR1(4,60)
      VRR0(4,89)=3.D0*V(68)-3.D0*V(69)+QCy*VRR0(4,60)+WQy*VRR1(4,60)
      VRR0(4,90)=4.D0*V(70)-4.D0*V(71)+QCy*VRR0(4,61)+WQy*VRR1(4,61)
      VRR0(4,91)=5.D0*r1x2E*VRR0(4,40)+QCy*VRR0(4,62)-5.D0*r1x2E*ZxZpE*VRR1(4,40)+WQy*VRR1(4,62)
      VRR0(4,92)=6.D0*r1x2E*VRR0(4,41)+QCy*VRR0(4,63)-6.D0*r1x2E*ZxZpE*VRR1(4,41)+WQy*VRR1(4,63)
      VRR0(4,93)=5.D0*r1x2E*VRR0(4,42)+QCx*VRR0(4,64)-5.D0*r1x2E*ZxZpE*VRR1(4,42)+WQx*VRR1(4,64)
      VRR0(4,94)=4.D0*r1x2E*VRR0(4,43)+QCx*VRR0(4,65)-4.D0*r1x2E*ZxZpE*VRR1(4,43)+WQx*VRR1(4,65)
      VRR0(4,95)=V(73)+V(75)+QCx*VRR0(4,66)+WQx*VRR1(4,66)
      VRR0(4,96)=2.D0*V(76)-2.D0*V(77)+QCx*VRR0(4,67)+WQx*VRR1(4,67)
      VRR0(4,97)=V(73)+V(75)+QCy*VRR0(4,67)+WQy*VRR1(4,67)
      VRR0(4,98)=4.D0*V(76)-4.D0*V(77)+QCy*VRR0(4,68)+WQy*VRR1(4,68)
      VRR0(4,99)=5.D0*r1x2E*VRR0(4,46)+QCy*VRR0(4,69)-5.D0*r1x2E*ZxZpE*VRR1(4,46)+WQy*VRR1(4,69)
      VRR0(4,100)=4.D0*V(78)-4.D0*V(79)+QCx*VRR0(4,70)+WQx*VRR1(4,70)
      VRR0(4,101)=V(81)+V(83)+QCx*VRR0(4,71)+WQx*VRR1(4,71)
      VRR0(4,102)=2.D0*V(84)-2.D0*V(85)+QCx*VRR0(4,72)+WQx*VRR1(4,72)
      VRR0(4,103)=2.D0*V(80)-2.D0*V(82)+QCy*VRR0(4,72)+WQy*VRR1(4,72)
      VRR0(4,104)=V(86)+V(87)+QCy*VRR0(4,73)+WQy*VRR1(4,73)
      VRR0(4,105)=4.D0*V(88)-4.D0*V(89)+QCy*VRR0(4,74)+WQy*VRR1(4,74)
      VRR0(4,106)=3.D0*V(90)-3.D0*V(91)+QCx*VRR0(4,75)+WQx*VRR1(4,75)
      VRR0(4,107)=V(93)+V(95)+QCx*VRR0(4,76)+WQx*VRR1(4,76)
      VRR0(4,108)=V(20)+2.D0*V(72)-2.D0*V(74)+QCz*VRR0(4,72)+WQz*VRR1(4,72)
      VRR0(4,109)=V(93)+V(95)+QCy*VRR0(4,77)+WQy*VRR1(4,77)
      VRR0(4,110)=3.D0*V(96)-3.D0*V(97)+QCy*VRR0(4,78)+WQy*VRR1(4,78)
      VRR0(4,111)=V(27)+3.D0*V(78)-3.D0*V(79)+QCz*VRR0(4,75)+WQz*VRR1(4,75)
      VRR0(4,112)=V(31)+V(81)+V(83)+QCz*VRR0(4,76)+WQz*VRR1(4,76)
      VRR0(4,113)=V(64)+V(86)+V(87)+QCz*VRR0(4,77)+WQz*VRR1(4,77)
      VRR0(4,114)=V(66)+3.D0*V(88)-3.D0*V(89)+QCz*VRR0(4,78)+WQz*VRR1(4,78)
      VRR0(4,115)=4.D0*V(90)-4.D0*V(91)+QCz*VRR0(4,79)+HfxZpE*VRR1(1,79)+WQz*VRR1(4,79)
      VRR0(4,116)=4.D0*V(92)-4.D0*V(94)+QCz*VRR0(4,80)+HfxZpE*VRR1(1,80)+WQz*VRR1(4,80)
      VRR0(4,117)=4.D0*V(96)-4.D0*V(97)+QCz*VRR0(4,81)+HfxZpE*VRR1(1,81)+WQz*VRR1(4,81)
      VRR0(4,118)=5.D0*r1x2E*VRR0(4,54)+QCz*VRR0(4,82)+HfxZpE*VRR1(1,82)-5.D0*r1x2E*ZxZpE*VRR1(4,54)+WQz*VRR1(4,82)
      VRR0(4,119)=5.D0*r1x2E*VRR0(4,55)+QCz*VRR0(4,83)+HfxZpE*VRR1(1,83)-5.D0*r1x2E*ZxZpE*VRR1(4,55)+WQz*VRR1(4,83)
      VRR0(4,120)=6.D0*r1x2E*VRR0(4,56)+QCz*VRR0(4,84)+HfxZpE*VRR1(1,84)-6.D0*r1x2E*ZxZpE*VRR1(4,56)+WQz*VRR1(4,84)
END SUBROUTINE VRRp0j0
