!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
MODULE SCFKeys
  CHARACTER(LEN=*), PARAMETER :: SCF_DENSITY_BUILD    = 'DensityBuild'

  CHARACTER(LEN=*), PARAMETER :: SCF_INKFOCK          = 'InkFok'
  CHARACTER(LEN=*), PARAMETER :: SCF_RESTART          = 'Restart'
  CHARACTER(LEN=*), PARAMETER :: SCF_PROJECTION       = 'Project'
  CHARACTER(LEN=*), PARAMETER :: SCF_GUESSEQCORE      = 'GuessEqCore'
  CHARACTER(LEN=*), PARAMETER :: SCF_EXTRAPOLATE      = 'Extrapolate'
  CHARACTER(LEN=*), PARAMETER :: SCF_SUPERPOSITION    = 'DensitySuperposition'
  CHARACTER(LEN=*), PARAMETER :: SCF_DENSITY_NORMAL   = 'DensityNormal'
  CHARACTER(LEN=*), PARAMETER :: SCF_BASISSETSWITCH   = 'BasisSetSwitch'
  CHARACTER(LEN=*), PARAMETER :: SCF_RWBSS            = 'RestartBasisSwitch'

  CHARACTER(LEN=*), PARAMETER :: SCF_FOCK_BUILD       = 'FockBuild'
  CHARACTER(LEN=*), PARAMETER :: SCF_SOLVE_SCF        = 'SCFSolving'

  CHARACTER(LEN=*), PARAMETER :: CPSCF_START_RESPONSE = 'StartResponse'
  CHARACTER(LEN=*), PARAMETER :: CPSCF_DENSITY_NORMAL = 'DensityPrime'
  CHARACTER(LEN=*), PARAMETER :: CPSCF_FOCK_BUILD     = 'FockPrimeBuild'
  CHARACTER(LEN=*), PARAMETER :: CPSCF_SOLVE_SCF      = 'CPSCFSolving'
END MODULE SCFKeys
