!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRd0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(5,38)
      V(2)=r1x2E*ZxZpE*VRR1(5,38)
      V(3)=r1x2E*VRR0(5,39)
      V(4)=HfxZpE*VRR1(2,60)
      V(5)=r1x2E*ZxZpE*VRR1(5,39)
      V(6)=r1x2E*VRR0(5,44)
      V(7)=3.D0*V(6)
      V(8)=r1x2E*ZxZpE*VRR1(5,44)
      V(9)=-3.D0*V(8)
      V(10)=r1x2E*VRR0(5,45)
      V(11)=HfxZpE*VRR1(2,67)
      V(12)=r1x2E*ZxZpE*VRR1(5,45)
      V(13)=r1x2E*VRR0(5,47)
      V(14)=r1x2E*ZxZpE*VRR1(5,47)
      V(15)=r1x2E*VRR0(5,48)
      V(16)=3.D0*V(15)
      V(17)=r1x2E*ZxZpE*VRR1(5,48)
      V(18)=-3.D0*V(17)
      V(19)=r1x2E*VRR0(5,49)
      V(20)=HfxZpE*VRR1(2,72)
      V(21)=r1x2E*ZxZpE*VRR1(5,49)
      V(22)=3.D0*V(19)
      V(23)=-3.D0*V(21)
      V(24)=r1x2E*VRR0(5,50)
      V(25)=r1x2E*ZxZpE*VRR1(5,50)
      V(26)=r1x2E*VRR0(5,51)
      V(27)=HfxZpE*VRR1(2,75)
      V(28)=r1x2E*ZxZpE*VRR1(5,51)
      V(29)=r1x2E*VRR0(5,52)
      V(30)=2.D0*V(29)
      V(31)=HfxZpE*VRR1(2,76)
      V(32)=r1x2E*ZxZpE*VRR1(5,52)
      V(33)=-2.D0*V(32)
      V(34)=r1x2E*VRR0(5,53)
      V(35)=r1x2E*ZxZpE*VRR1(5,53)
      V(36)=r1x2E*VRR0(6,38)
      V(37)=r1x2E*ZxZpE*VRR1(6,38)
      V(38)=r1x2E*VRR0(6,39)
      V(39)=HfxZpE*VRR1(3,60)
      V(40)=r1x2E*ZxZpE*VRR1(6,39)
      V(41)=r1x2E*VRR0(6,44)
      V(42)=3.D0*V(41)
      V(43)=r1x2E*ZxZpE*VRR1(6,44)
      V(44)=-3.D0*V(43)
      V(45)=r1x2E*VRR0(6,45)
      V(46)=HfxZpE*VRR1(3,67)
      V(47)=r1x2E*ZxZpE*VRR1(6,45)
      V(48)=r1x2E*VRR0(6,47)
      V(49)=r1x2E*ZxZpE*VRR1(6,47)
      V(50)=r1x2E*VRR0(6,48)
      V(51)=3.D0*V(50)
      V(52)=r1x2E*ZxZpE*VRR1(6,48)
      V(53)=-3.D0*V(52)
      V(54)=r1x2E*VRR0(6,49)
      V(55)=HfxZpE*VRR1(3,72)
      V(56)=r1x2E*ZxZpE*VRR1(6,49)
      V(57)=3.D0*V(54)
      V(58)=-3.D0*V(56)
      V(59)=r1x2E*VRR0(6,50)
      V(60)=r1x2E*ZxZpE*VRR1(6,50)
      V(61)=r1x2E*VRR0(6,51)
      V(62)=HfxZpE*VRR1(3,75)
      V(63)=r1x2E*ZxZpE*VRR1(6,51)
      V(64)=r1x2E*VRR0(6,52)
      V(65)=2.D0*V(64)
      V(66)=HfxZpE*VRR1(3,76)
      V(67)=r1x2E*ZxZpE*VRR1(6,52)
      V(68)=-2.D0*V(67)
      V(69)=HfxZpE*VRR1(2,77)
      V(70)=r1x2E*VRR0(6,53)
      V(71)=HfxZpE*VRR1(2,78)
      V(72)=r1x2E*ZxZpE*VRR1(6,53)
      V(73)=r1x2E*VRR0(7,38)
      V(74)=r1x2E*ZxZpE*VRR1(7,38)
      V(75)=r1x2E*VRR0(7,39)
      V(76)=r1x2E*ZxZpE*VRR1(7,39)
      V(77)=r1x2E*VRR0(7,44)
      V(78)=3.D0*V(77)
      V(79)=r1x2E*ZxZpE*VRR1(7,44)
      V(80)=-3.D0*V(79)
      V(81)=r1x2E*VRR0(7,45)
      V(82)=r1x2E*ZxZpE*VRR1(7,45)
      V(83)=r1x2E*VRR0(7,47)
      V(84)=r1x2E*ZxZpE*VRR1(7,47)
      V(85)=r1x2E*VRR0(7,48)
      V(86)=3.D0*V(85)
      V(87)=r1x2E*ZxZpE*VRR1(7,48)
      V(88)=-3.D0*V(87)
      V(89)=r1x2E*VRR0(7,49)
      V(90)=r1x2E*ZxZpE*VRR1(7,49)
      V(91)=3.D0*V(89)
      V(92)=-3.D0*V(90)
      V(93)=r1x2E*VRR0(7,50)
      V(94)=r1x2E*ZxZpE*VRR1(7,50)
      V(95)=r1x2E*VRR0(7,51)
      V(96)=r1x2E*ZxZpE*VRR1(7,51)
      V(97)=r1x2E*VRR0(7,52)
      V(98)=2.D0*V(97)
      V(99)=r1x2E*ZxZpE*VRR1(7,52)
      V(100)=-2.D0*V(99)
      V(101)=HfxZpE*VRR1(3,77)
      V(102)=r1x2E*VRR0(7,53)
      V(103)=HfxZpE*VRR1(3,78)
      V(104)=r1x2E*ZxZpE*VRR1(7,53)
      V(105)=r1x2E*VRR0(8,38)
      V(106)=r1x2E*ZxZpE*VRR1(8,38)
      V(107)=r1x2E*VRR0(8,39)
      V(108)=HfxZpE*VRR1(4,60)
      V(109)=r1x2E*ZxZpE*VRR1(8,39)
      V(110)=r1x2E*VRR0(8,44)
      V(111)=3.D0*V(110)
      V(112)=r1x2E*ZxZpE*VRR1(8,44)
      V(113)=-3.D0*V(112)
      V(114)=r1x2E*VRR0(8,45)
      V(115)=HfxZpE*VRR1(4,67)
      V(116)=r1x2E*ZxZpE*VRR1(8,45)
      V(117)=r1x2E*VRR0(8,47)
      V(118)=r1x2E*ZxZpE*VRR1(8,47)
      V(119)=r1x2E*VRR0(8,48)
      V(120)=3.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(8,48)
      V(122)=-3.D0*V(121)
      V(123)=r1x2E*VRR0(8,49)
      V(124)=HfxZpE*VRR1(4,72)
      V(125)=r1x2E*ZxZpE*VRR1(8,49)
      V(126)=3.D0*V(123)
      V(127)=-3.D0*V(125)
      V(128)=r1x2E*VRR0(8,50)
      V(129)=r1x2E*ZxZpE*VRR1(8,50)
      V(130)=r1x2E*VRR0(8,51)
      V(131)=HfxZpE*VRR1(4,75)
      V(132)=r1x2E*ZxZpE*VRR1(8,51)
      V(133)=r1x2E*VRR0(8,52)
      V(134)=2.D0*V(133)
      V(135)=HfxZpE*VRR1(4,76)
      V(136)=r1x2E*ZxZpE*VRR1(8,52)
      V(137)=-2.D0*V(136)
      V(138)=r1x2E*VRR0(8,53)
      V(139)=r1x2E*ZxZpE*VRR1(8,53)
      V(140)=r1x2E*VRR0(9,38)
      V(141)=r1x2E*ZxZpE*VRR1(9,38)
      V(142)=r1x2E*VRR0(9,39)
      V(143)=r1x2E*ZxZpE*VRR1(9,39)
      V(144)=r1x2E*VRR0(9,44)
      V(145)=3.D0*V(144)
      V(146)=r1x2E*ZxZpE*VRR1(9,44)
      V(147)=-3.D0*V(146)
      V(148)=r1x2E*VRR0(9,45)
      V(149)=r1x2E*ZxZpE*VRR1(9,45)
      V(150)=r1x2E*VRR0(9,47)
      V(151)=r1x2E*ZxZpE*VRR1(9,47)
      V(152)=r1x2E*VRR0(9,48)
      V(153)=3.D0*V(152)
      V(154)=r1x2E*ZxZpE*VRR1(9,48)
      V(155)=-3.D0*V(154)
      V(156)=r1x2E*VRR0(9,49)
      V(157)=r1x2E*ZxZpE*VRR1(9,49)
      V(158)=3.D0*V(156)
      V(159)=-3.D0*V(157)
      V(160)=r1x2E*VRR0(9,50)
      V(161)=r1x2E*ZxZpE*VRR1(9,50)
      V(162)=r1x2E*VRR0(9,51)
      V(163)=r1x2E*ZxZpE*VRR1(9,51)
      V(164)=r1x2E*VRR0(9,52)
      V(165)=2.D0*V(164)
      V(166)=r1x2E*ZxZpE*VRR1(9,52)
      V(167)=-2.D0*V(166)
      V(168)=HfxZpE*VRR1(4,77)
      V(169)=r1x2E*VRR0(9,53)
      V(170)=HfxZpE*VRR1(4,78)
      V(171)=r1x2E*ZxZpE*VRR1(9,53)
      V(172)=r1x2E*VRR0(10,38)
      V(173)=r1x2E*ZxZpE*VRR1(10,38)
      V(174)=r1x2E*VRR0(10,39)
      V(175)=r1x2E*ZxZpE*VRR1(10,39)
      V(176)=r1x2E*VRR0(10,44)
      V(177)=3.D0*V(176)
      V(178)=r1x2E*ZxZpE*VRR1(10,44)
      V(179)=-3.D0*V(178)
      V(180)=r1x2E*VRR0(10,45)
      V(181)=r1x2E*ZxZpE*VRR1(10,45)
      V(182)=r1x2E*VRR0(10,47)
      V(183)=r1x2E*ZxZpE*VRR1(10,47)
      V(184)=r1x2E*VRR0(10,48)
      V(185)=3.D0*V(184)
      V(186)=r1x2E*ZxZpE*VRR1(10,48)
      V(187)=-3.D0*V(186)
      V(188)=r1x2E*VRR0(10,49)
      V(189)=r1x2E*ZxZpE*VRR1(10,49)
      V(190)=3.D0*V(188)
      V(191)=-3.D0*V(189)
      V(192)=r1x2E*VRR0(10,50)
      V(193)=r1x2E*ZxZpE*VRR1(10,50)
      V(194)=r1x2E*VRR0(10,51)
      V(195)=r1x2E*ZxZpE*VRR1(10,51)
      V(196)=r1x2E*VRR0(10,52)
      V(197)=2.D0*V(196)
      V(198)=r1x2E*ZxZpE*VRR1(10,52)
      V(199)=-2.D0*V(198)
      V(200)=r1x2E*VRR0(10,53)
      V(201)=r1x2E*ZxZpE*VRR1(10,53)
      VRR0(5,85)=6.D0*r1x2E*VRR0(5,36)+QCx*VRR0(5,57)+2.D0*HfxZpE*VRR1(2,57)-6.D0*r1x2E*ZxZpE*VRR1(5,36)+WQx*VRR1(5,57)
      VRR0(5,86)=5.D0*r1x2E*VRR0(5,37)+QCx*VRR0(5,58)+2.D0*HfxZpE*VRR1(2,58)-5.D0*r1x2E*ZxZpE*VRR1(5,37)+WQx*VRR1(5,58)
      VRR0(5,87)=4.D0*V(1)-4.D0*V(2)+QCx*VRR0(5,59)+2.D0*HfxZpE*VRR1(2,59)+WQx*VRR1(5,59)
      VRR0(5,88)=3.D0*V(3)+2.D0*V(4)-3.D0*V(5)+QCx*VRR0(5,60)+WQx*VRR1(5,60)
      VRR0(5,89)=3.D0*V(1)-3.D0*V(2)+QCy*VRR0(5,60)+WQy*VRR1(5,60)
      VRR0(5,90)=4.D0*V(3)-4.D0*V(5)+QCy*VRR0(5,61)+WQy*VRR1(5,61)
      VRR0(5,91)=5.D0*r1x2E*VRR0(5,40)+QCy*VRR0(5,62)-5.D0*r1x2E*ZxZpE*VRR1(5,40)+WQy*VRR1(5,62)
      VRR0(5,92)=6.D0*r1x2E*VRR0(5,41)+QCy*VRR0(5,63)-6.D0*r1x2E*ZxZpE*VRR1(5,41)+WQy*VRR1(5,63)
      VRR0(5,93)=5.D0*r1x2E*VRR0(5,42)+QCx*VRR0(5,64)+2.D0*HfxZpE*VRR1(2,64)-5.D0*r1x2E*ZxZpE*VRR1(5,42)+WQx*VRR1(5,64)
      VRR0(5,94)=4.D0*r1x2E*VRR0(5,43)+QCx*VRR0(5,65)+2.D0*HfxZpE*VRR1(2,65)-4.D0*r1x2E*ZxZpE*VRR1(5,43)+WQx*VRR1(5,65)
      VRR0(5,95)=V(7)+V(9)+QCx*VRR0(5,66)+2.D0*HfxZpE*VRR1(2,66)+WQx*VRR1(5,66)
      VRR0(5,96)=2.D0*V(10)+2.D0*V(11)-2.D0*V(12)+QCx*VRR0(5,67)+WQx*VRR1(5,67)
      VRR0(5,97)=V(7)+V(9)+QCy*VRR0(5,67)+WQy*VRR1(5,67)
      VRR0(5,98)=4.D0*V(10)-4.D0*V(12)+QCy*VRR0(5,68)+WQy*VRR1(5,68)
      VRR0(5,99)=5.D0*r1x2E*VRR0(5,46)+QCy*VRR0(5,69)-5.D0*r1x2E*ZxZpE*VRR1(5,46)+WQy*VRR1(5,69)
      VRR0(5,100)=4.D0*V(13)-4.D0*V(14)+QCx*VRR0(5,70)+2.D0*HfxZpE*VRR1(2,70)+WQx*VRR1(5,70)
      VRR0(5,101)=V(16)+V(18)+QCx*VRR0(5,71)+2.D0*HfxZpE*VRR1(2,71)+WQx*VRR1(5,71)
      VRR0(5,102)=2.D0*V(19)+2.D0*V(20)-2.D0*V(21)+QCx*VRR0(5,72)+WQx*VRR1(5,72)
      VRR0(5,103)=2.D0*V(15)-2.D0*V(17)+QCy*VRR0(5,72)+WQy*VRR1(5,72)
      VRR0(5,104)=V(22)+V(23)+QCy*VRR0(5,73)+WQy*VRR1(5,73)
      VRR0(5,105)=4.D0*V(24)-4.D0*V(25)+QCy*VRR0(5,74)+WQy*VRR1(5,74)
      VRR0(5,106)=3.D0*V(26)+2.D0*V(27)-3.D0*V(28)+QCx*VRR0(5,75)+WQx*VRR1(5,75)
      VRR0(5,107)=V(30)+2.D0*V(31)+V(33)+QCx*VRR0(5,76)+WQx*VRR1(5,76)
      VRR0(5,108)=2.D0*V(6)-2.D0*V(8)+QCz*VRR0(5,72)+WQz*VRR1(5,72)
      VRR0(5,109)=V(30)+V(33)+QCy*VRR0(5,77)+WQy*VRR1(5,77)
      VRR0(5,110)=3.D0*V(34)-3.D0*V(35)+QCy*VRR0(5,78)+WQy*VRR1(5,78)
      VRR0(5,111)=3.D0*V(13)-3.D0*V(14)+QCz*VRR0(5,75)+WQz*VRR1(5,75)
      VRR0(5,112)=V(16)+V(18)+QCz*VRR0(5,76)+WQz*VRR1(5,76)
      VRR0(5,113)=V(22)+V(23)+QCz*VRR0(5,77)+WQz*VRR1(5,77)
      VRR0(5,114)=3.D0*V(24)-3.D0*V(25)+QCz*VRR0(5,78)+WQz*VRR1(5,78)
      VRR0(5,115)=4.D0*V(26)-4.D0*V(28)+QCz*VRR0(5,79)+WQz*VRR1(5,79)
      VRR0(5,116)=4.D0*V(29)-4.D0*V(32)+QCz*VRR0(5,80)+WQz*VRR1(5,80)
      VRR0(5,117)=4.D0*V(34)-4.D0*V(35)+QCz*VRR0(5,81)+WQz*VRR1(5,81)
      VRR0(5,118)=5.D0*r1x2E*VRR0(5,54)+QCz*VRR0(5,82)-5.D0*r1x2E*ZxZpE*VRR1(5,54)+WQz*VRR1(5,82)
      VRR0(5,119)=5.D0*r1x2E*VRR0(5,55)+QCz*VRR0(5,83)-5.D0*r1x2E*ZxZpE*VRR1(5,55)+WQz*VRR1(5,83)
      VRR0(5,120)=6.D0*r1x2E*VRR0(5,56)+QCz*VRR0(5,84)-6.D0*r1x2E*ZxZpE*VRR1(5,56)+WQz*VRR1(5,84)
      VRR0(6,85)=6.D0*r1x2E*VRR0(6,36)+QCx*VRR0(6,57)+HfxZpE*VRR1(3,57)-6.D0*r1x2E*ZxZpE*VRR1(6,36)+WQx*VRR1(6,57)
      VRR0(6,86)=5.D0*r1x2E*VRR0(6,37)+QCx*VRR0(6,58)+HfxZpE*VRR1(3,58)-5.D0*r1x2E*ZxZpE*VRR1(6,37)+WQx*VRR1(6,58)
      VRR0(6,87)=4.D0*V(36)-4.D0*V(37)+QCx*VRR0(6,59)+HfxZpE*VRR1(3,59)+WQx*VRR1(6,59)
      VRR0(6,88)=3.D0*V(38)+V(39)-3.D0*V(40)+QCx*VRR0(6,60)+WQx*VRR1(6,60)
      VRR0(6,89)=V(4)+3.D0*V(36)-3.D0*V(37)+QCy*VRR0(6,60)+WQy*VRR1(6,60)
      VRR0(6,90)=4.D0*V(38)-4.D0*V(40)+QCy*VRR0(6,61)+HfxZpE*VRR1(2,61)+WQy*VRR1(6,61)
      VRR0(6,91)=5.D0*r1x2E*VRR0(6,40)+QCy*VRR0(6,62)+HfxZpE*VRR1(2,62)-5.D0*r1x2E*ZxZpE*VRR1(6,40)+WQy*VRR1(6,62)
      VRR0(6,92)=6.D0*r1x2E*VRR0(6,41)+QCy*VRR0(6,63)+HfxZpE*VRR1(2,63)-6.D0*r1x2E*ZxZpE*VRR1(6,41)+WQy*VRR1(6,63)
      VRR0(6,93)=5.D0*r1x2E*VRR0(6,42)+QCx*VRR0(6,64)+HfxZpE*VRR1(3,64)-5.D0*r1x2E*ZxZpE*VRR1(6,42)+WQx*VRR1(6,64)
      VRR0(6,94)=4.D0*r1x2E*VRR0(6,43)+QCx*VRR0(6,65)+HfxZpE*VRR1(3,65)-4.D0*r1x2E*ZxZpE*VRR1(6,43)+WQx*VRR1(6,65)
      VRR0(6,95)=V(42)+V(44)+QCx*VRR0(6,66)+HfxZpE*VRR1(3,66)+WQx*VRR1(6,66)
      VRR0(6,96)=2.D0*V(45)+V(46)-2.D0*V(47)+QCx*VRR0(6,67)+WQx*VRR1(6,67)
      VRR0(6,97)=V(11)+V(42)+V(44)+QCy*VRR0(6,67)+WQy*VRR1(6,67)
      VRR0(6,98)=4.D0*V(45)-4.D0*V(47)+QCy*VRR0(6,68)+HfxZpE*VRR1(2,68)+WQy*VRR1(6,68)
      VRR0(6,99)=5.D0*r1x2E*VRR0(6,46)+QCy*VRR0(6,69)+HfxZpE*VRR1(2,69)-5.D0*r1x2E*ZxZpE*VRR1(6,46)+WQy*VRR1(6,69)
      VRR0(6,100)=4.D0*V(48)-4.D0*V(49)+QCx*VRR0(6,70)+HfxZpE*VRR1(3,70)+WQx*VRR1(6,70)
      VRR0(6,101)=V(51)+V(53)+QCx*VRR0(6,71)+HfxZpE*VRR1(3,71)+WQx*VRR1(6,71)
      VRR0(6,102)=2.D0*V(54)+V(55)-2.D0*V(56)+QCx*VRR0(6,72)+WQx*VRR1(6,72)
      VRR0(6,103)=V(20)+2.D0*V(50)-2.D0*V(52)+QCy*VRR0(6,72)+WQy*VRR1(6,72)
      VRR0(6,104)=V(57)+V(58)+QCy*VRR0(6,73)+HfxZpE*VRR1(2,73)+WQy*VRR1(6,73)
      VRR0(6,105)=4.D0*V(59)-4.D0*V(60)+QCy*VRR0(6,74)+HfxZpE*VRR1(2,74)+WQy*VRR1(6,74)
      VRR0(6,106)=3.D0*V(61)+V(62)-3.D0*V(63)+QCx*VRR0(6,75)+WQx*VRR1(6,75)
      VRR0(6,107)=V(65)+V(66)+V(68)+QCx*VRR0(6,76)+WQx*VRR1(6,76)
      VRR0(6,108)=2.D0*V(41)-2.D0*V(43)+QCz*VRR0(6,72)+WQz*VRR1(6,72)
      VRR0(6,109)=V(65)+V(68)+V(69)+QCy*VRR0(6,77)+WQy*VRR1(6,77)
      VRR0(6,110)=3.D0*V(70)+V(71)-3.D0*V(72)+QCy*VRR0(6,78)+WQy*VRR1(6,78)
      VRR0(6,111)=3.D0*V(48)-3.D0*V(49)+QCz*VRR0(6,75)+WQz*VRR1(6,75)
      VRR0(6,112)=V(51)+V(53)+QCz*VRR0(6,76)+WQz*VRR1(6,76)
      VRR0(6,113)=V(57)+V(58)+QCz*VRR0(6,77)+WQz*VRR1(6,77)
      VRR0(6,114)=3.D0*V(59)-3.D0*V(60)+QCz*VRR0(6,78)+WQz*VRR1(6,78)
      VRR0(6,115)=4.D0*V(61)-4.D0*V(63)+QCz*VRR0(6,79)+WQz*VRR1(6,79)
      VRR0(6,116)=4.D0*V(64)-4.D0*V(67)+QCz*VRR0(6,80)+WQz*VRR1(6,80)
      VRR0(6,117)=4.D0*V(70)-4.D0*V(72)+QCz*VRR0(6,81)+WQz*VRR1(6,81)
      VRR0(6,118)=5.D0*r1x2E*VRR0(6,54)+QCz*VRR0(6,82)-5.D0*r1x2E*ZxZpE*VRR1(6,54)+WQz*VRR1(6,82)
      VRR0(6,119)=5.D0*r1x2E*VRR0(6,55)+QCz*VRR0(6,83)-5.D0*r1x2E*ZxZpE*VRR1(6,55)+WQz*VRR1(6,83)
      VRR0(6,120)=6.D0*r1x2E*VRR0(6,56)+QCz*VRR0(6,84)-6.D0*r1x2E*ZxZpE*VRR1(6,56)+WQz*VRR1(6,84)
      VRR0(7,85)=6.D0*r1x2E*VRR0(7,36)+QCx*VRR0(7,57)-6.D0*r1x2E*ZxZpE*VRR1(7,36)+WQx*VRR1(7,57)
      VRR0(7,86)=5.D0*r1x2E*VRR0(7,37)+QCx*VRR0(7,58)-5.D0*r1x2E*ZxZpE*VRR1(7,37)+WQx*VRR1(7,58)
      VRR0(7,87)=4.D0*V(73)-4.D0*V(74)+QCx*VRR0(7,59)+WQx*VRR1(7,59)
      VRR0(7,88)=3.D0*V(75)-3.D0*V(76)+QCx*VRR0(7,60)+WQx*VRR1(7,60)
      VRR0(7,89)=2.D0*V(39)+3.D0*V(73)-3.D0*V(74)+QCy*VRR0(7,60)+WQy*VRR1(7,60)
      VRR0(7,90)=4.D0*V(75)-4.D0*V(76)+QCy*VRR0(7,61)+2.D0*HfxZpE*VRR1(3,61)+WQy*VRR1(7,61)
      VRR0(7,91)=5.D0*r1x2E*VRR0(7,40)+QCy*VRR0(7,62)+2.D0*HfxZpE*VRR1(3,62)-5.D0*r1x2E*ZxZpE*VRR1(7,40)+WQy*VRR1(7,62)
      VRR0(7,92)=6.D0*r1x2E*VRR0(7,41)+QCy*VRR0(7,63)+2.D0*HfxZpE*VRR1(3,63)-6.D0*r1x2E*ZxZpE*VRR1(7,41)+WQy*VRR1(7,63)
      VRR0(7,93)=5.D0*r1x2E*VRR0(7,42)+QCx*VRR0(7,64)-5.D0*r1x2E*ZxZpE*VRR1(7,42)+WQx*VRR1(7,64)
      VRR0(7,94)=4.D0*r1x2E*VRR0(7,43)+QCx*VRR0(7,65)-4.D0*r1x2E*ZxZpE*VRR1(7,43)+WQx*VRR1(7,65)
      VRR0(7,95)=V(78)+V(80)+QCx*VRR0(7,66)+WQx*VRR1(7,66)
      VRR0(7,96)=2.D0*V(81)-2.D0*V(82)+QCx*VRR0(7,67)+WQx*VRR1(7,67)
      VRR0(7,97)=2.D0*V(46)+V(78)+V(80)+QCy*VRR0(7,67)+WQy*VRR1(7,67)
      VRR0(7,98)=4.D0*V(81)-4.D0*V(82)+QCy*VRR0(7,68)+2.D0*HfxZpE*VRR1(3,68)+WQy*VRR1(7,68)
      VRR0(7,99)=5.D0*r1x2E*VRR0(7,46)+QCy*VRR0(7,69)+2.D0*HfxZpE*VRR1(3,69)-5.D0*r1x2E*ZxZpE*VRR1(7,46)+WQy*VRR1(7,69)
      VRR0(7,100)=4.D0*V(83)-4.D0*V(84)+QCx*VRR0(7,70)+WQx*VRR1(7,70)
      VRR0(7,101)=V(86)+V(88)+QCx*VRR0(7,71)+WQx*VRR1(7,71)
      VRR0(7,102)=2.D0*V(89)-2.D0*V(90)+QCx*VRR0(7,72)+WQx*VRR1(7,72)
      VRR0(7,103)=2.D0*V(55)+2.D0*V(85)-2.D0*V(87)+QCy*VRR0(7,72)+WQy*VRR1(7,72)
      VRR0(7,104)=V(91)+V(92)+QCy*VRR0(7,73)+2.D0*HfxZpE*VRR1(3,73)+WQy*VRR1(7,73)
      VRR0(7,105)=4.D0*V(93)-4.D0*V(94)+QCy*VRR0(7,74)+2.D0*HfxZpE*VRR1(3,74)+WQy*VRR1(7,74)
      VRR0(7,106)=3.D0*V(95)-3.D0*V(96)+QCx*VRR0(7,75)+WQx*VRR1(7,75)
      VRR0(7,107)=V(98)+V(100)+QCx*VRR0(7,76)+WQx*VRR1(7,76)
      VRR0(7,108)=2.D0*V(77)-2.D0*V(79)+QCz*VRR0(7,72)+WQz*VRR1(7,72)
      VRR0(7,109)=V(98)+V(100)+2.D0*V(101)+QCy*VRR0(7,77)+WQy*VRR1(7,77)
      VRR0(7,110)=3.D0*V(102)+2.D0*V(103)-3.D0*V(104)+QCy*VRR0(7,78)+WQy*VRR1(7,78)
      VRR0(7,111)=3.D0*V(83)-3.D0*V(84)+QCz*VRR0(7,75)+WQz*VRR1(7,75)
      VRR0(7,112)=V(86)+V(88)+QCz*VRR0(7,76)+WQz*VRR1(7,76)
      VRR0(7,113)=V(91)+V(92)+QCz*VRR0(7,77)+WQz*VRR1(7,77)
      VRR0(7,114)=3.D0*V(93)-3.D0*V(94)+QCz*VRR0(7,78)+WQz*VRR1(7,78)
      VRR0(7,115)=4.D0*V(95)-4.D0*V(96)+QCz*VRR0(7,79)+WQz*VRR1(7,79)
      VRR0(7,116)=4.D0*V(97)-4.D0*V(99)+QCz*VRR0(7,80)+WQz*VRR1(7,80)
      VRR0(7,117)=4.D0*V(102)-4.D0*V(104)+QCz*VRR0(7,81)+WQz*VRR1(7,81)
      VRR0(7,118)=5.D0*r1x2E*VRR0(7,54)+QCz*VRR0(7,82)-5.D0*r1x2E*ZxZpE*VRR1(7,54)+WQz*VRR1(7,82)
      VRR0(7,119)=5.D0*r1x2E*VRR0(7,55)+QCz*VRR0(7,83)-5.D0*r1x2E*ZxZpE*VRR1(7,55)+WQz*VRR1(7,83)
      VRR0(7,120)=6.D0*r1x2E*VRR0(7,56)+QCz*VRR0(7,84)-6.D0*r1x2E*ZxZpE*VRR1(7,56)+WQz*VRR1(7,84)
      VRR0(8,85)=6.D0*r1x2E*VRR0(8,36)+QCx*VRR0(8,57)+HfxZpE*VRR1(4,57)-6.D0*r1x2E*ZxZpE*VRR1(8,36)+WQx*VRR1(8,57)
      VRR0(8,86)=5.D0*r1x2E*VRR0(8,37)+QCx*VRR0(8,58)+HfxZpE*VRR1(4,58)-5.D0*r1x2E*ZxZpE*VRR1(8,37)+WQx*VRR1(8,58)
      VRR0(8,87)=4.D0*V(105)-4.D0*V(106)+QCx*VRR0(8,59)+HfxZpE*VRR1(4,59)+WQx*VRR1(8,59)
      VRR0(8,88)=3.D0*V(107)+V(108)-3.D0*V(109)+QCx*VRR0(8,60)+WQx*VRR1(8,60)
      VRR0(8,89)=3.D0*V(105)-3.D0*V(106)+QCy*VRR0(8,60)+WQy*VRR1(8,60)
      VRR0(8,90)=4.D0*V(107)-4.D0*V(109)+QCy*VRR0(8,61)+WQy*VRR1(8,61)
      VRR0(8,91)=5.D0*r1x2E*VRR0(8,40)+QCy*VRR0(8,62)-5.D0*r1x2E*ZxZpE*VRR1(8,40)+WQy*VRR1(8,62)
      VRR0(8,92)=6.D0*r1x2E*VRR0(8,41)+QCy*VRR0(8,63)-6.D0*r1x2E*ZxZpE*VRR1(8,41)+WQy*VRR1(8,63)
      VRR0(8,93)=5.D0*r1x2E*VRR0(8,42)+QCx*VRR0(8,64)+HfxZpE*VRR1(4,64)-5.D0*r1x2E*ZxZpE*VRR1(8,42)+WQx*VRR1(8,64)
      VRR0(8,94)=4.D0*r1x2E*VRR0(8,43)+QCx*VRR0(8,65)+HfxZpE*VRR1(4,65)-4.D0*r1x2E*ZxZpE*VRR1(8,43)+WQx*VRR1(8,65)
      VRR0(8,95)=V(111)+V(113)+QCx*VRR0(8,66)+HfxZpE*VRR1(4,66)+WQx*VRR1(8,66)
      VRR0(8,96)=2.D0*V(114)+V(115)-2.D0*V(116)+QCx*VRR0(8,67)+WQx*VRR1(8,67)
      VRR0(8,97)=V(111)+V(113)+QCy*VRR0(8,67)+WQy*VRR1(8,67)
      VRR0(8,98)=4.D0*V(114)-4.D0*V(116)+QCy*VRR0(8,68)+WQy*VRR1(8,68)
      VRR0(8,99)=5.D0*r1x2E*VRR0(8,46)+QCy*VRR0(8,69)-5.D0*r1x2E*ZxZpE*VRR1(8,46)+WQy*VRR1(8,69)
      VRR0(8,100)=4.D0*V(117)-4.D0*V(118)+QCx*VRR0(8,70)+HfxZpE*VRR1(4,70)+WQx*VRR1(8,70)
      VRR0(8,101)=V(120)+V(122)+QCx*VRR0(8,71)+HfxZpE*VRR1(4,71)+WQx*VRR1(8,71)
      VRR0(8,102)=2.D0*V(123)+V(124)-2.D0*V(125)+QCx*VRR0(8,72)+WQx*VRR1(8,72)
      VRR0(8,103)=2.D0*V(119)-2.D0*V(121)+QCy*VRR0(8,72)+WQy*VRR1(8,72)
      VRR0(8,104)=V(126)+V(127)+QCy*VRR0(8,73)+WQy*VRR1(8,73)
      VRR0(8,105)=4.D0*V(128)-4.D0*V(129)+QCy*VRR0(8,74)+WQy*VRR1(8,74)
      VRR0(8,106)=3.D0*V(130)+V(131)-3.D0*V(132)+QCx*VRR0(8,75)+WQx*VRR1(8,75)
      VRR0(8,107)=V(134)+V(135)+V(137)+QCx*VRR0(8,76)+WQx*VRR1(8,76)
      VRR0(8,108)=V(20)+2.D0*V(110)-2.D0*V(112)+QCz*VRR0(8,72)+WQz*VRR1(8,72)
      VRR0(8,109)=V(134)+V(137)+QCy*VRR0(8,77)+WQy*VRR1(8,77)
      VRR0(8,110)=3.D0*V(138)-3.D0*V(139)+QCy*VRR0(8,78)+WQy*VRR1(8,78)
      VRR0(8,111)=V(27)+3.D0*V(117)-3.D0*V(118)+QCz*VRR0(8,75)+WQz*VRR1(8,75)
      VRR0(8,112)=V(31)+V(120)+V(122)+QCz*VRR0(8,76)+WQz*VRR1(8,76)
      VRR0(8,113)=V(69)+V(126)+V(127)+QCz*VRR0(8,77)+WQz*VRR1(8,77)
      VRR0(8,114)=V(71)+3.D0*V(128)-3.D0*V(129)+QCz*VRR0(8,78)+WQz*VRR1(8,78)
      VRR0(8,115)=4.D0*V(130)-4.D0*V(132)+QCz*VRR0(8,79)+HfxZpE*VRR1(2,79)+WQz*VRR1(8,79)
      VRR0(8,116)=4.D0*V(133)-4.D0*V(136)+QCz*VRR0(8,80)+HfxZpE*VRR1(2,80)+WQz*VRR1(8,80)
      VRR0(8,117)=4.D0*V(138)-4.D0*V(139)+QCz*VRR0(8,81)+HfxZpE*VRR1(2,81)+WQz*VRR1(8,81)
      VRR0(8,118)=5.D0*r1x2E*VRR0(8,54)+QCz*VRR0(8,82)+HfxZpE*VRR1(2,82)-5.D0*r1x2E*ZxZpE*VRR1(8,54)+WQz*VRR1(8,82)
      VRR0(8,119)=5.D0*r1x2E*VRR0(8,55)+QCz*VRR0(8,83)+HfxZpE*VRR1(2,83)-5.D0*r1x2E*ZxZpE*VRR1(8,55)+WQz*VRR1(8,83)
      VRR0(8,120)=6.D0*r1x2E*VRR0(8,56)+QCz*VRR0(8,84)+HfxZpE*VRR1(2,84)-6.D0*r1x2E*ZxZpE*VRR1(8,56)+WQz*VRR1(8,84)
      VRR0(9,85)=6.D0*r1x2E*VRR0(9,36)+QCx*VRR0(9,57)-6.D0*r1x2E*ZxZpE*VRR1(9,36)+WQx*VRR1(9,57)
      VRR0(9,86)=5.D0*r1x2E*VRR0(9,37)+QCx*VRR0(9,58)-5.D0*r1x2E*ZxZpE*VRR1(9,37)+WQx*VRR1(9,58)
      VRR0(9,87)=4.D0*V(140)-4.D0*V(141)+QCx*VRR0(9,59)+WQx*VRR1(9,59)
      VRR0(9,88)=3.D0*V(142)-3.D0*V(143)+QCx*VRR0(9,60)+WQx*VRR1(9,60)
      VRR0(9,89)=V(108)+3.D0*V(140)-3.D0*V(141)+QCy*VRR0(9,60)+WQy*VRR1(9,60)
      VRR0(9,90)=4.D0*V(142)-4.D0*V(143)+QCy*VRR0(9,61)+HfxZpE*VRR1(4,61)+WQy*VRR1(9,61)
      VRR0(9,91)=5.D0*r1x2E*VRR0(9,40)+QCy*VRR0(9,62)+HfxZpE*VRR1(4,62)-5.D0*r1x2E*ZxZpE*VRR1(9,40)+WQy*VRR1(9,62)
      VRR0(9,92)=6.D0*r1x2E*VRR0(9,41)+QCy*VRR0(9,63)+HfxZpE*VRR1(4,63)-6.D0*r1x2E*ZxZpE*VRR1(9,41)+WQy*VRR1(9,63)
      VRR0(9,93)=5.D0*r1x2E*VRR0(9,42)+QCx*VRR0(9,64)-5.D0*r1x2E*ZxZpE*VRR1(9,42)+WQx*VRR1(9,64)
      VRR0(9,94)=4.D0*r1x2E*VRR0(9,43)+QCx*VRR0(9,65)-4.D0*r1x2E*ZxZpE*VRR1(9,43)+WQx*VRR1(9,65)
      VRR0(9,95)=V(145)+V(147)+QCx*VRR0(9,66)+WQx*VRR1(9,66)
      VRR0(9,96)=2.D0*V(148)-2.D0*V(149)+QCx*VRR0(9,67)+WQx*VRR1(9,67)
      VRR0(9,97)=V(115)+V(145)+V(147)+QCy*VRR0(9,67)+WQy*VRR1(9,67)
      VRR0(9,98)=4.D0*V(148)-4.D0*V(149)+QCy*VRR0(9,68)+HfxZpE*VRR1(4,68)+WQy*VRR1(9,68)
      VRR0(9,99)=5.D0*r1x2E*VRR0(9,46)+QCy*VRR0(9,69)+HfxZpE*VRR1(4,69)-5.D0*r1x2E*ZxZpE*VRR1(9,46)+WQy*VRR1(9,69)
      VRR0(9,100)=4.D0*V(150)-4.D0*V(151)+QCx*VRR0(9,70)+WQx*VRR1(9,70)
      VRR0(9,101)=V(153)+V(155)+QCx*VRR0(9,71)+WQx*VRR1(9,71)
      VRR0(9,102)=2.D0*V(156)-2.D0*V(157)+QCx*VRR0(9,72)+WQx*VRR1(9,72)
      VRR0(9,103)=V(124)+2.D0*V(152)-2.D0*V(154)+QCy*VRR0(9,72)+WQy*VRR1(9,72)
      VRR0(9,104)=V(158)+V(159)+QCy*VRR0(9,73)+HfxZpE*VRR1(4,73)+WQy*VRR1(9,73)
      VRR0(9,105)=4.D0*V(160)-4.D0*V(161)+QCy*VRR0(9,74)+HfxZpE*VRR1(4,74)+WQy*VRR1(9,74)
      VRR0(9,106)=3.D0*V(162)-3.D0*V(163)+QCx*VRR0(9,75)+WQx*VRR1(9,75)
      VRR0(9,107)=V(165)+V(167)+QCx*VRR0(9,76)+WQx*VRR1(9,76)
      VRR0(9,108)=V(55)+2.D0*V(144)-2.D0*V(146)+QCz*VRR0(9,72)+WQz*VRR1(9,72)
      VRR0(9,109)=V(165)+V(167)+V(168)+QCy*VRR0(9,77)+WQy*VRR1(9,77)
      VRR0(9,110)=3.D0*V(169)+V(170)-3.D0*V(171)+QCy*VRR0(9,78)+WQy*VRR1(9,78)
      VRR0(9,111)=V(62)+3.D0*V(150)-3.D0*V(151)+QCz*VRR0(9,75)+WQz*VRR1(9,75)
      VRR0(9,112)=V(66)+V(153)+V(155)+QCz*VRR0(9,76)+WQz*VRR1(9,76)
      VRR0(9,113)=V(101)+V(158)+V(159)+QCz*VRR0(9,77)+WQz*VRR1(9,77)
      VRR0(9,114)=V(103)+3.D0*V(160)-3.D0*V(161)+QCz*VRR0(9,78)+WQz*VRR1(9,78)
      VRR0(9,115)=4.D0*V(162)-4.D0*V(163)+QCz*VRR0(9,79)+HfxZpE*VRR1(3,79)+WQz*VRR1(9,79)
      VRR0(9,116)=4.D0*V(164)-4.D0*V(166)+QCz*VRR0(9,80)+HfxZpE*VRR1(3,80)+WQz*VRR1(9,80)
      VRR0(9,117)=4.D0*V(169)-4.D0*V(171)+QCz*VRR0(9,81)+HfxZpE*VRR1(3,81)+WQz*VRR1(9,81)
      VRR0(9,118)=5.D0*r1x2E*VRR0(9,54)+QCz*VRR0(9,82)+HfxZpE*VRR1(3,82)-5.D0*r1x2E*ZxZpE*VRR1(9,54)+WQz*VRR1(9,82)
      VRR0(9,119)=5.D0*r1x2E*VRR0(9,55)+QCz*VRR0(9,83)+HfxZpE*VRR1(3,83)-5.D0*r1x2E*ZxZpE*VRR1(9,55)+WQz*VRR1(9,83)
      VRR0(9,120)=6.D0*r1x2E*VRR0(9,56)+QCz*VRR0(9,84)+HfxZpE*VRR1(3,84)-6.D0*r1x2E*ZxZpE*VRR1(9,56)+WQz*VRR1(9,84)
      VRR0(10,85)=6.D0*r1x2E*VRR0(10,36)+QCx*VRR0(10,57)-6.D0*r1x2E*ZxZpE*VRR1(10,36)+WQx*VRR1(10,57)
      VRR0(10,86)=5.D0*r1x2E*VRR0(10,37)+QCx*VRR0(10,58)-5.D0*r1x2E*ZxZpE*VRR1(10,37)+WQx*VRR1(10,58)
      VRR0(10,87)=4.D0*V(172)-4.D0*V(173)+QCx*VRR0(10,59)+WQx*VRR1(10,59)
      VRR0(10,88)=3.D0*V(174)-3.D0*V(175)+QCx*VRR0(10,60)+WQx*VRR1(10,60)
      VRR0(10,89)=3.D0*V(172)-3.D0*V(173)+QCy*VRR0(10,60)+WQy*VRR1(10,60)
      VRR0(10,90)=4.D0*V(174)-4.D0*V(175)+QCy*VRR0(10,61)+WQy*VRR1(10,61)
      VRR0(10,91)=5.D0*r1x2E*VRR0(10,40)+QCy*VRR0(10,62)-5.D0*r1x2E*ZxZpE*VRR1(10,40)+WQy*VRR1(10,62)
      VRR0(10,92)=6.D0*r1x2E*VRR0(10,41)+QCy*VRR0(10,63)-6.D0*r1x2E*ZxZpE*VRR1(10,41)+WQy*VRR1(10,63)
      VRR0(10,93)=5.D0*r1x2E*VRR0(10,42)+QCx*VRR0(10,64)-5.D0*r1x2E*ZxZpE*VRR1(10,42)+WQx*VRR1(10,64)
      VRR0(10,94)=4.D0*r1x2E*VRR0(10,43)+QCx*VRR0(10,65)-4.D0*r1x2E*ZxZpE*VRR1(10,43)+WQx*VRR1(10,65)
      VRR0(10,95)=V(177)+V(179)+QCx*VRR0(10,66)+WQx*VRR1(10,66)
      VRR0(10,96)=2.D0*V(180)-2.D0*V(181)+QCx*VRR0(10,67)+WQx*VRR1(10,67)
      VRR0(10,97)=V(177)+V(179)+QCy*VRR0(10,67)+WQy*VRR1(10,67)
      VRR0(10,98)=4.D0*V(180)-4.D0*V(181)+QCy*VRR0(10,68)+WQy*VRR1(10,68)
      VRR0(10,99)=5.D0*r1x2E*VRR0(10,46)+QCy*VRR0(10,69)-5.D0*r1x2E*ZxZpE*VRR1(10,46)+WQy*VRR1(10,69)
      VRR0(10,100)=4.D0*V(182)-4.D0*V(183)+QCx*VRR0(10,70)+WQx*VRR1(10,70)
      VRR0(10,101)=V(185)+V(187)+QCx*VRR0(10,71)+WQx*VRR1(10,71)
      VRR0(10,102)=2.D0*V(188)-2.D0*V(189)+QCx*VRR0(10,72)+WQx*VRR1(10,72)
      VRR0(10,103)=2.D0*V(184)-2.D0*V(186)+QCy*VRR0(10,72)+WQy*VRR1(10,72)
      VRR0(10,104)=V(190)+V(191)+QCy*VRR0(10,73)+WQy*VRR1(10,73)
      VRR0(10,105)=4.D0*V(192)-4.D0*V(193)+QCy*VRR0(10,74)+WQy*VRR1(10,74)
      VRR0(10,106)=3.D0*V(194)-3.D0*V(195)+QCx*VRR0(10,75)+WQx*VRR1(10,75)
      VRR0(10,107)=V(197)+V(199)+QCx*VRR0(10,76)+WQx*VRR1(10,76)
      VRR0(10,108)=2.D0*V(124)+2.D0*V(176)-2.D0*V(178)+QCz*VRR0(10,72)+WQz*VRR1(10,72)
      VRR0(10,109)=V(197)+V(199)+QCy*VRR0(10,77)+WQy*VRR1(10,77)
      VRR0(10,110)=3.D0*V(200)-3.D0*V(201)+QCy*VRR0(10,78)+WQy*VRR1(10,78)
      VRR0(10,111)=2.D0*V(131)+3.D0*V(182)-3.D0*V(183)+QCz*VRR0(10,75)+WQz*VRR1(10,75)
      VRR0(10,112)=2.D0*V(135)+V(185)+V(187)+QCz*VRR0(10,76)+WQz*VRR1(10,76)
      VRR0(10,113)=2.D0*V(168)+V(190)+V(191)+QCz*VRR0(10,77)+WQz*VRR1(10,77)
      VRR0(10,114)=2.D0*V(170)+3.D0*V(192)-3.D0*V(193)+QCz*VRR0(10,78)+WQz*VRR1(10,78)
      VRR0(10,115)=4.D0*V(194)-4.D0*V(195)+QCz*VRR0(10,79)+2.D0*HfxZpE*VRR1(4,79)+WQz*VRR1(10,79)
      VRR0(10,116)=4.D0*V(196)-4.D0*V(198)+QCz*VRR0(10,80)+2.D0*HfxZpE*VRR1(4,80)+WQz*VRR1(10,80)
      VRR0(10,117)=4.D0*V(200)-4.D0*V(201)+QCz*VRR0(10,81)+2.D0*HfxZpE*VRR1(4,81)+WQz*VRR1(10,81)
      VRR0(10,118)=5.D0*r1x2E*VRR0(10,54)+QCz*VRR0(10,82)+2.D0*HfxZpE*VRR1(4,82)-5.D0*r1x2E*ZxZpE*VRR1(10,54)+WQz*VRR1(10,82)
      VRR0(10,119)=5.D0*r1x2E*VRR0(10,55)+QCz*VRR0(10,83)+2.D0*HfxZpE*VRR1(4,83)-5.D0*r1x2E*ZxZpE*VRR1(10,55)+WQz*VRR1(10,83)
      VRR0(10,120)=6.D0*r1x2E*VRR0(10,56)+QCz*VRR0(10,84)+2.D0*HfxZpE*VRR1(4,84)-6.D0*r1x2E*ZxZpE*VRR1(10,56)+WQz*VRR1(10,84)
END SUBROUTINE VRRd0j0
