/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif

void
runDoof2dSetup(double* a, double* b, int n)
{
  int i, j;

  for (j = 0; j <= n - 1; j++)
  {
    for (i = 0; i <= n - 1; i++)
    {
      a[i + n * j] = 0.0;
      b[i + n * j] = 0.0;
    }
  }
  b[n / 2 - 1 + n * (n / 2 - 1)] = 1000.0;
}

/* Doof2d kernels */

void
runDoof2dInCRestrict(double *restrict a, double *restrict b, int n) {
  int i, j, k;
  double fact = 1.0 / 9.0;

  runDoof2dSetup(a, b, n);

  for (k = 0; k < 5; ++k)
  {
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        a[i + n * j] = fact *
          (b[i + 1 + n * (j + 1)] + b[i + 1 + n * j] + b[i + 1 + n * (j - 1)] +
           b[i + n * (j + 1)] + b[i + n * j] + b[i + n * (j - 1)] +
           b[i - 1 + n * (j + 1)] + b[i - 1 + n * j] + b[i - 1 + n * (j - 1)]);
      }
    }
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        b[i + n * j] = fact *
          (a[i + 1 + n * (j + 1)] + a[i + 1 + n * j] + a[i + 1 + n * (j - 1)] +
           a[i + n * (j + 1)] + a[i + n * j] + a[i + n * (j - 1)] +
           a[i - 1 + n * (j + 1)] + a[i - 1 + n * j] + a[i - 1 + n * (j - 1)]);
      }
    }
  }
}

void
runDoof2dCoefsInCRestrict(double *restrict a, double* restrict b, 
  double* c, int n) {
  int i, j, k;
  double fact = 1.0 / 9.0;
  const double c1 = c[0], c2 = c[1], c3 = c[2], c4 = c[3], c5 = c[4],
               c6 = c[5], c7 = c[6], c8 = c[7], c9 = c[8];

  runDoof2dSetup(a, b, n);

  for (k = 0; k < 5; ++k)
  {
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        a[i + n * j] = fact *
          (c1 * b[i + 1 + n * (j + 1)] + c2 * b[i + 1 + n * j] +
           c3 * b[i + 1 + n * (j - 1)] + c4 * b[i + n * (j + 1)] +
           c5 * b[i + n * j] + c6 * b[i + n * (j - 1)] +
           c7 * b[i - 1 + n * (j + 1)] + c8 * b[i - 1 + n * j] +
           c9 * b[i - 1 + n * (j - 1)]);
      }
    }
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        b[i + n * j] = fact *
          (c1 * a[i + 1 + n * (j + 1)] + c2 * a[i + 1 + n * j] +
           c3 * a[i + 1 + n * (j - 1)] + c4 * a[i + n * (j + 1)] +
           c5 * a[i + n * j] + c6 * a[i + n * (j - 1)] +
           c7 * a[i - 1 + n * (j + 1)] + c8 * a[i - 1 + n * j] +
           c9 * a[i - 1 + n * (j - 1)]);
      }
    }
  }
}

void
runDoof2dInC(double* a, double* b, int n)
{
  int i, j, k;
  double fact = 1.0 / 9.0;

  runDoof2dSetup(a, b, n);

  for (k = 0; k < 5; ++k)
  {
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        a[i + n * j] = fact *
          (b[i + 1 + n * (j + 1)] + b[i + 1 + n * j] + b[i + 1 + n * (j - 1)] +
           b[i + n * (j + 1)] + b[i + n * j] + b[i + n * (j - 1)] +
           b[i - 1 + n * (j + 1)] + b[i - 1 + n * j] + b[i - 1 + n * (j - 1)]);
      }
    }
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        b[i + n * j] = fact *
          (a[i + 1 + n * (j + 1)] + a[i + 1 + n * j] + a[i + 1 + n * (j - 1)] +
	 a[i + n * (j + 1)] + a[i + n * j] + a[i + n * (j - 1)] +
           a[i - 1 + n * (j + 1)] + a[i - 1 + n * j] + a[i - 1 + n * (j - 1)]);
      }
    }
  }
}

void
runDoof2dCoefsInC(double* a, double* b, 
  double* c, int n) {
  int i, j, k;
  double fact = 1.0 / 9.0;
  const double c1 = c[0], c2 = c[1], c3 = c[2], c4 = c[3], c5 = c[4],
               c6 = c[5], c7 = c[6], c8 = c[7], c9 = c[8];

  runDoof2dSetup(a, b, n);

  for (k = 0; k < 5; ++k)
  {
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        a[i + n * j] = fact *
          (c1 * b[i + 1 + n * (j + 1)] + c2 * b[i + 1 + n * j] +
           c3 * b[i + 1 + n * (j - 1)] + c4 * b[i + n * (j + 1)] +
           c5 * b[i + n * j] + c6 * b[i + n * (j - 1)] +
           c7 * b[i - 1 + n * (j + 1)] + c8 * b[i - 1 + n * j] +
           c9 * b[i - 1 + n * (j - 1)]);
      }
    }
    for (j = 1; j <= n - 2; j++) {
      for (i = 1; i <= n - 2; i++) {
        b[i + n * j] = fact *
          (c1 * a[i + 1 + n * (j + 1)] + c2 * a[i + 1 + n * j] +
           c3 * a[i + 1 + n * (j - 1)] + c4 * a[i + n * (j + 1)] +
           c5 * a[i + n * j] + c6 * a[i + n * (j - 1)] +
           c7 * a[i - 1 + n * (j + 1)] + c8 * a[i - 1 + n * j] +
           c9 * a[i - 1 + n * (j - 1)]);
      }
    }
  }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: Doof2dInC.c,v $   $Author: richard $
 * $Revision: 1.17 $   $Date: 2004/11/01 18:15:11 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
