// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Doof3d Benchmark
//-----------------------------------------------------------------------------

// include files

#include "Doof3dInP2.h"
#include "Doof3dInCppTran.h"
#include "Doof3dInC.h"


//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv);

  // Run 27pt doof3d.

  Benchmark doof3d(argc, argv, "27 Pt");

#if !POOMA_NO_RESTRICT
  doof3d.addImplementation(new Doof3dInC<true>());
#endif
  doof3d.addImplementation(new Doof3dInC<false>());
  doof3d.addImplementation(new Doof3dInCppTran);
  doof3d.addImplementation(new Doof3dInP2UnOpt);
  doof3d.addImplementation(new Doof3dInP2Opt);

  doof3d.setSamplingParameters(10,0,1);
  doof3d.run();

  Pooma::finalize();
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Doof3d.cpp,v $   $Author: richard $
// $Revision: 1.7 $   $Date: 2004/11/01 18:15:12 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
