// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Classes Doof3dInCppTran.
//-----------------------------------------------------------------------------

#ifndef POOMA_BENCHMARKS_DOOF3D_DOOF3DINCPPTRAN_H
#define POOMA_BENCHMARKS_DOOF3D_DOOF3DINCPPTRAN_H

// include files

#include "Pooma/Arrays.h"
#include "Utilities/Benchmark.h"

#include <stdlib.h>


//-----------------------------------------------------------------------------
// Doof3dInCppTran class definition.
//-----------------------------------------------------------------------------

class Doof3dInCppTran : public Implementation {
public:

  // Typedefs for the Array types we'll be using here.

  typedef Array<3,double,Brick> Array3D;

  // This is a CppTran benchmark

  const char *type() const { return CppTranType(); }

  void initialize(int n) {
    // get new array domain
    Interval<1> N(1, n);
    Interval<3> newDomain(N, N, N);

    // Reset the size of member Arrays.
    a_m.initialize(newDomain);
    b_m.initialize(newDomain);

    // Save the problem size.
    n_m = n;

    // Intialize Array element values.
    setInitialConditions();
  }

  void run() 
  {
    int i, j, k;
    const double fact = 1.0 / 9.0;

    Pooma::blockAndEvaluate();
    
    for (k = 2; k <= n_m - 1; k++) 
      {
        for (j = 2; j <= n_m - 1; j++) 
          {
            for (i = 2; i <= n_m - 1; i++) 
              {
                b_m(i,j,k) = fact * (
                  a_m(i-1,j-1,k-1) + a_m(i,  j-1,k-1) + a_m(i+1,j-1,k-1) +
                  a_m(i-1,j,  k-1) + a_m(i,  j,  k-1) + a_m(i+1,j,  k-1) +
                  a_m(i-1,j+1,k-1) + a_m(i,  j+1,k-1) + a_m(i+1,j+1,k-1) +
                  a_m(i-1,j-1,k  ) + a_m(i,  j-1,k  ) + a_m(i+1,j-1,k  ) +
                  a_m(i-1,j,  k  ) + a_m(i,  j,  k  ) + a_m(i+1,j,  k  ) +
                  a_m(i-1,j+1,k  ) + a_m(i,  j+1,k  ) + a_m(i+1,j+1,k  ) +
                  a_m(i-1,j-1,k+1) + a_m(i,  j-1,k+1) + a_m(i+1,j-1,k+1) +
                  a_m(i-1,j,  k+1) + a_m(i,  j,  k+1) + a_m(i+1,j,  k+1) +
                  a_m(i-1,j+1,k+1) + a_m(i,  j+1,k+1) + a_m(i+1,j+1,k+1));
              }
          }
      }
     
    // save result for checking 
    check_m = b_m(n_m / 2, n_m / 2, n_m / 2);
  }

  // Return value for checking result of benchmark run.

  double resultCheck() const { return check_m; }

  // Return number of flops in this kernel.

  double opCount() const
  {
    return ( 27 * (n_m - 2) * (n_m - 2) * (n_m - 2) );
  }

private:

  void setInitialConditions()
  {
    Pooma::blockAndEvaluate();
    
    // initialize arrays
    for (int k=1; k<=n_m; ++k) {
      for (int j=1; j<=n_m; ++j) {
        for (int i=1; i<=n_m; ++i) {
          a_m(i,j,k) = 1.1 * n_m;
          b_m(i,j,k) = 0.0;
        }
      }
    }
  }

  // 3D Data Arrays.

  Array3D a_m, b_m;

  // Problem check value.

  double check_m;

  // Problem Size.

  int n_m;

};

#endif // POOMA_BENCHMARKS_DOOF3D_DOOF3DINCPPTRAN_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Doof3dInCppTran.h,v $   $Author: richard $
// $Revision: 1.12 $   $Date: 2004/11/01 18:15:12 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
