// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
// ----------------------------------------------------------------------
// Test the tulip core messaging speed
// Use one round of messaging, which gives a lot of small messages.
// ----------------------------------------------------------------------

#ifdef POOMA_BENCHMARKS_MESSAGING_TULIP

#ifndef POOMA_BENCHMARKS_MESSAGING_TULIP_CORE_ONE_ROUND_H
#define POOMA_BENCHMARKS_MESSAGING_TULIP_CORE_ONE_ROUND_H

// ----------------------------------------------------------------------
// Include files.
// ----------------------------------------------------------------------

#include <iostream>
#include "tulip_core.h"
#include "Utilities/Benchmark.h"

// ----------------------------------------------------------------------
// Class TulipCoreOneRound
// ----------------------------------------------------------------------

class TulipCoreOneRound : public Implementation
{
  //
  // A utility function to calculate the neighbor processors for any
  // given processor.
  //
  int *makeNeighbors();

public:

  //
  // Constructor.
  //
  // dim:       The number of dimensions, generally 1, 2 or 3.
  // tiling:    A list of the number of tiles in each direction.
  // elems: The number of elements in each direction within a patch.
  // guards:    The number of guard cells in each direction.
  //
  TulipCoreOneRound(int dim, int *tiling, int guards);

  //
  // Destructor.
  //
  ~TulipCoreOneRound();

  //
  // Call the type TC1 for TulipCoreRound 1
  // This has no qualifications, so return an empty string.
  //
  const char *type() const { return "TC1"; }
  const char *qualification() const { return ""; }

  //
  // Initialize the local patch, clean up any existing patch first.
  //
  void initialize(int n);

  //
  // Do a run, which includes filling guard cells and some computation.
  //
  void run();

  //
  // Return value for checking result of benchmark run.
  // Ignore for the moment.
  //
  double resultCheck() const { return 0; }

  //
  // Return number of ops in this kernel.
  // Ignore for now.
  //
  double opCount() const { return 1; }

private:

  //
  // The data we need for the benchmark.
  //
  // dim_m:  The number of dimensions. Generally 1, 2 or 3.
  // elems_m:  The number of elements in each direction in a patch.
  // guards_m: The number of guard cells in each direction.
  // numNeighbors_m: The number of neighbors a patch has (3^dim_m).
  // totalElems_m: The total number of elements including guard cells.
  // tiling_m: The number of patches in each direction.
  // strides_m: The strides in the neighbors array.
  // myLoc_m: The vector position of this patch.
  // neighbors_m: The neighbors of this patch.
  // data_m: The data we will be exchanging and computing with.
  // 
  //

  int dim_m;
  int elems_m;
  int guards_m;
  int numNeighbors_m;
  int totalElems_m;
  int *tiling_m;
  int *strides_m;
  int *myLoc_m;
  int *neighbors_m;
  double *data_m;
};

#endif // POOMA_BENCHMARKS_MESSAGING_TULIP_CORE_ONE_ROUND_H

#endif // POOMA_BENCHMARKS_MESSAGING_TULIP
