// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Class atestInCppTran.
//-----------------------------------------------------------------------------

#ifndef POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINCPPTRAN_H
#define POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINCPPTRAN_H

// include files

#include "Pooma/Arrays.h"
#include "Utilities/Benchmark.h"


//-----------------------------------------------------------------------------
// atestInCppTran class definition.
//-----------------------------------------------------------------------------

class atestInCppTran : public Implementation {
public:

  // Typedefs for the Array types we'll be using here.

  typedef Array<2,double,Brick> Array2D;

  // This is a CppTran benchmark

  const char* type() const { return CppTranType(); }

  void initialize(int n) {
    // get new array domain
    Interval<1> N(1, n);
    Interval<2> newDomain(N, N);

    // Reset the size of member Arrays.
    w_m.initialize(newDomain);
    x_m.initialize(newDomain);
    y_m.initialize(newDomain);
    z_m.initialize(newDomain);

    // Save the problem size.
    n_m = n;

    // Set the initial conditions.
    setInitialConditions();
  }

  // run benchmark
  void run() {
    // reset result array w_m
    for (int j = 1; j <= n_m; j++)
      for (int i = 1; i <= n_m; i++)
        w_m(i,j) = 1.1 * n_m;

    // computational kernel
    for (int j = 1; j <= n_m; j++) {
      for (int i = 1; i <= n_m; i++) {
        w_m(i,j) += x_m(i,j) + y_m(i,j) + z_m(i,j);
      }
    }
     
    // save result for checking 
    check_m = w_m(n_m/2,n_m/2);
  }

  // just run setup
  void runSetup() {
    // reset result array w_m
    for (int j = 1; j <= n_m; j++)
      for (int i = 1; i <= n_m; i++)
        w_m(i,j) = 1.1 * n_m;
  }

  // Return value for checking result of benchmark run.

  double resultCheck() const { return check_m; }

  // Return number of flops in this kernel.

  double opCount() const { return (3 * (double)n_m * (double)n_m); }

private:

  void setInitialConditions() {
    for (int j = 1; j <= n_m; j++) {
      for (int i = 1; i <= n_m; i++) {
        x_m(i,j) = 2.2 * n_m;
        y_m(i,j) = 3.3 * n_m;
        z_m(i,j) = 4.4 * n_m;
      }
    }
  }

  // 2D Data Arrays.

  Array2D w_m, x_m, y_m, z_m;

  // Problem check value.

  double check_m;

  // Problem Size.

  int n_m;

};

#endif // POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINCPPTRAN_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: atestInCppTran.h,v $   $Author: richard $
// $Revision: 1.19 $   $Date: 2004/11/01 18:15:16 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
