// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Class atestInP2.
//-----------------------------------------------------------------------------

#ifndef POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINP2_H
#define POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINP2_H

// include files

#include "Pooma/Arrays.h"
#include "Utilities/Benchmark.h"


//-----------------------------------------------------------------------------
// atestInP2 class definition.
//-----------------------------------------------------------------------------

class atestInP2 : public Implementation
{
public:

  // Typedefs for the Array types we'll be using here.

  typedef Array<2,double,Brick> Array2D;

  // This is a Pooma II benchmark

  const char* type() const { return P2Type(); }

  void initialize(int n) {
    // get new array domain
    Interval<1> N(1, n);
    Interval<2> newDomain(N, N);

    // Reset the size of member Arrays.
    w_m.initialize(newDomain);
    x_m.initialize(newDomain);
    y_m.initialize(newDomain);
    z_m.initialize(newDomain);

    // Save the problem size.
    n_m = n;

    // Set up the initial conditions.
    setInitialConditions();
  }

  // run benchmark
  void run() {
    // reset result array w_m
    w_m = 1.1 * n_m;

    Pooma::blockAndEvaluate();

    // computational kernel
    w_m += x_m + y_m + z_m;

    Pooma::blockAndEvaluate();

    // save results for checking
    check_m = w_m(n_m/2,n_m/2);
  }

  // just run setup
  void runSetup() {
    // reset result array w_m
    w_m = 1.1 * n_m;

    Pooma::blockAndEvaluate();
  }

  // Return value for checking result of benchmark run.

  double resultCheck() const { return check_m; }

  // Return number of flops in this kernel.

  double opCount() const { return (3 * (double)n_m * (double)n_m); }

private:

  void setInitialConditions() {
    // initialize arrays
    x_m = 2.2 * n_m;
    y_m = 3.3 * n_m;
    z_m = 4.4 * n_m;

    Pooma::blockAndEvaluate();
  }

  // 2D Data Arrays.

  Array2D w_m, x_m, y_m, z_m;

  // Problem check value.

  double check_m;

  // Problem Size.

  int n_m;

};

#endif // POOMA_BENCHMARKS_SIMPLEARRAY_ATESTINP2_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: atestInP2.h,v $   $Author: richard $
// $Revision: 1.19 $   $Date: 2004/11/01 18:15:16 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
