// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Conjugate-Gradient Poisson solver.
// Solves -Laplace(x)=f,
//     f(z) = 1, 1/3<z1<2/3, 1/3<z2<2/3
//     f(z) = 0 otherwise
//     x = 0 on z1=0,z1=1,z2=0,z2=1
//-----------------------------------------------------------------------------

// include files

#include "CGAInC.h"
#include "CGAInCppTran.h"
#include "CGAInP2.h"

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);

  Benchmark CgA(argc, argv);
  
  CgA.addImplementation(new CgAInC);
  CgA.addImplementation(new CgAInCppTran);
  CgA.addImplementation(new CgAInP2<false>);
  CgA.addImplementation(new CgAInP2<true>(CgA.numPatches()));

  CgA.setSamplingParameters(10,1,4);
  CgA.setIterations(100);  
  CgA.run();

  Pooma::finalize();
    
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: CGA.cpp,v $   $Author: richard $
// $Revision: 1.16 $   $Date: 2004/11/01 18:15:18 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
